/*REGIONAL POPULATION PROJECTION MODEL

//Simple age and sex specific population projection model.
//INPUTS: Age specific fertility rates [FERT], sex ratios (at birth)[SR]...
//...age and sex specific survival rates, age and sex specific net migration [NM]
//Subscripts are for female [_F] and male [_M] which can be changed later to
//include other dimensions eg ethnicity
//Preliminaries include: File path, data, dimensions = years[t] and ages[k] and gender [j].

//INPUT*/
mata
/*Two constants required for the Transition matrix operations(a) male
//fertility and (b) ratio of sexes per live birth*/
male_fertility = 0
births_sex_ratio = (105.5/205.5,100/205.5)

/*DIMENSIONS*/
/*Projection length, periods*/
Ps = 2021
Pe = 2050
/*Projection_t = 2021:2050
//Length of historical data series*/
Ts = 1992
Te = 2020
/*Set population series length, history plus projection
*Time_t = 1992:2050*/
Time_length = Pe - Ts + 1
TL = Time_length
Time_t = 1992..2050
/*Length of history
*History_length = length(History_t)*/
History_length = Te - Ts+1
HL = History_length

/*Length of projection
//Projection_length = length(Projection_t)*/
Projection_length = Pe - Ps + 1

/*Set number of age groups and variable for k-1 (ages)*/
Ages = (0..100)
Ages_n = 101
k_minus_one = Ages_n-1

/*Set Household Living arrangement types (LATRs)*/
LATR_n = (1..11)

LATR_str =("onep_c" , "twop_c" , "alon_a",  "mult_o", "cple_o", "onep_o", "twop_o", "onep_a", "cple_a", "twop_a", "nonprv")
HH_str =("alone" , "onep" , "twop" , "multif" , "multi" , "cple")


nor = 1
akl = 2
wai = 3
bop = 4
tar = 5
man = 6
wel = 7
can = 8
otg = 9
sth = 10
gis = 11
usi = 12
/*Set number of regions*/
Reg_n = (1..12)
Regl = length(Reg_n)
Reg_str = ("NOR", "AKL", "WAI", "BOP", "TAR", "MAN", "WEL", "CAN", "OTG", "STH", "GIS", "USI")
Reg_str_s = ("nor", "akl", "wai", "bop", "tar", "man", "wel", "can", "otg", "sth", "gis", "usi")

/*lfpr age bands*/
lfpr_bands = 1..11
lfpr_bands_n = length(lfpr_bands)

/*INITIALISE
//Initialise: Create (a) contenated age and sex specific population matrices with last year of history
//and zeros for projections
//(b) Empty transition matrices
//(c) matrices of sex specifice survival probabilities
//(d) concatenated full LATR series, history and fcast
//(e) Growth variables
//(f) Net migration matrices
//male labour force participation rates with history - note the minus one as this data tends to be most recent
//female labour force participation rates with history - note the minus one as this data tends to be most recent*/
pop_fcast_f = (pop_hist_f[History_length,.]\ J(Projection_length,length(Ages),0))
pop_fcast_m = (pop_hist_m[History_length,.]\ J(Projection_length,length(Ages),0))
T_f = J(length(Ages),length(Ages),0)
T_m = J(length(Ages),length(Ages),0)
survival_f = 1:-mortality_f
survival_m = 1:-mortality_m
lfpr_fcast_m = (lfpr_m[1..History_length,.]\ J(Projection_length,lfpr_bands_n, 0))	
lfpr_fcast_f = (lfpr_f[1..History_length,.]\ J(Projection_length,lfpr_bands_n, 0)) 
lf_growth = J(Time_length,1,1)
unemployment_fcast_rate = (unemployment_rate[1..History_length,.] \ J(Projection_length,1,0)) 
employment_growth = J(Time_length,1,0)
onep_age_growth = J(Time_length,1,0)
twop_age_growth = J(Time_length,1,0)
alon_age_growth = J(Time_length,1,0)
mult_age_growth = J(Time_length,1,0)
cple_age_growth = J(Time_length,1,0)
multif_age_growth = J(Time_length,1,0)


nor_pop_fcast_f = (reg_pop_hist_f[1..HL,.]\ J(Projection_length,length(Ages),0))
nor_pop_fcast_m = (reg_pop_hist_m[1..HL,.]\ J(Projection_length,length(Ages),0))

akl_pop_fcast_f = (reg_pop_hist_f[2*HL-HL+1..HL*2,.]\ J(Projection_length,length(Ages),0))
akl_pop_fcast_m = (reg_pop_hist_m[2*HL-HL+1..HL*2,.]\ J(Projection_length,length(Ages),0))

wai_pop_fcast_f = (reg_pop_hist_f[3*HL-HL+1..HL*3,.]\ J(Projection_length,length(Ages),0))
wai_pop_fcast_m = (reg_pop_hist_m[3*HL-HL+1..HL*3,.]\ J(Projection_length,length(Ages),0))

bop_pop_fcast_f = (reg_pop_hist_f[4*HL-HL+1..HL*4,.]\ J(Projection_length,length(Ages),0))
bop_pop_fcast_m = (reg_pop_hist_m[4*HL-HL+1..HL*4,.]\ J(Projection_length,length(Ages),0))

tar_pop_fcast_f = (reg_pop_hist_f[5*HL-HL+1..HL*5,.]\ J(Projection_length,length(Ages),0))
tar_pop_fcast_m = (reg_pop_hist_m[5*HL-HL+1..HL*5,.]\ J(Projection_length,length(Ages),0))

man_pop_fcast_f = (reg_pop_hist_f[6*HL-HL+1..HL*6,.]\ J(Projection_length,length(Ages),0))
man_pop_fcast_m = (reg_pop_hist_m[6*HL-HL+1..HL*6,.]\ J(Projection_length,length(Ages),0))

wel_pop_fcast_f = (reg_pop_hist_f[7*HL-HL+1..HL*7,.]\ J(Projection_length,length(Ages),0))
wel_pop_fcast_m = (reg_pop_hist_m[7*HL-HL+1..HL*7,.]\ J(Projection_length,length(Ages),0))

can_pop_fcast_f = (reg_pop_hist_f[8*HL-HL+1..HL*8,.]\ J(Projection_length,length(Ages),0))
can_pop_fcast_m = (reg_pop_hist_m[8*HL-HL+1..HL*8,.]\ J(Projection_length,length(Ages),0))

otg_pop_fcast_f = (reg_pop_hist_f[9*HL-HL+1..HL*9,.]\ J(Projection_length,length(Ages),0))
otg_pop_fcast_m = (reg_pop_hist_m[9*HL-HL+1..HL*9,.]\ J(Projection_length,length(Ages),0))

sth_pop_fcast_f = (reg_pop_hist_f[10*HL-HL+1..HL*10,.]\ J(Projection_length,length(Ages),0))
sth_pop_fcast_m = (reg_pop_hist_m[10*HL-HL+1..HL*10,.]\ J(Projection_length,length(Ages),0))

gis_pop_fcast_f = (reg_pop_hist_f[11*HL-HL+1..HL*11,.]\ J(Projection_length,length(Ages),0))
gis_pop_fcast_m = (reg_pop_hist_m[11*HL-HL+1..HL*11,.]\ J(Projection_length,length(Ages),0))

usi_pop_fcast_f = (reg_pop_hist_f[12*HL-HL+1..HL*12,.]\ J(Projection_length,length(Ages),0))
usi_pop_fcast_m = (reg_pop_hist_m[12*HL-HL+1..HL*12,.]\ J(Projection_length,length(Ages),0))


/* below if you face NULL pointer error drop matrices:  mata drop nor_onep* nor_twop* nor_alon* nor_mult_* nor_cple_* nor_nonp* */
for(i=1; i<=length(Reg_str_s); i++){
	for(j=1; j<=length(LATR_str); j++){
		p = crexternal(Reg_str_s[i]+"_"+LATR_str[j]+"_age_growth")
		Reg_str_s[i]+"_"+LATR_str[j]+"_age_growth"
		*p = J(Time_length,1,0) 
}
}


{
nor_onep_age_growth = J(Time_length,1,0) 
nor_twop_age_growth = J(Time_length,1,0) 
nor_alon_age_growth = J(Time_length,1,0) 
nor_mult_age_growth = J(Time_length,1,0) 
nor_cple_age_growth = J(Time_length,1,0) 
nor_multif_age_growth = J(Time_length,1,0)  

akl_onep_age_growth = J(Time_length,1,0) 
akl_twop_age_growth = J(Time_length,1,0) 
akl_alon_age_growth = J(Time_length,1,0) 
akl_mult_age_growth = J(Time_length,1,0) 
akl_cple_age_growth = J(Time_length,1,0) 
akl_multif_age_growth = J(Time_length,1,0)  

wai_onep_age_growth = J(Time_length,1,0) 
wai_twop_age_growth = J(Time_length,1,0) 
wai_alon_age_growth = J(Time_length,1,0) 
wai_mult_age_growth = J(Time_length,1,0) 
wai_cple_age_growth = J(Time_length,1,0) 
wai_multif_age_growth = J(Time_length,1,0)  

bop_onep_age_growth = J(Time_length,1,0) 
bop_twop_age_growth = J(Time_length,1,0) 
bop_alon_age_growth = J(Time_length,1,0) 
bop_mult_age_growth = J(Time_length,1,0) 
bop_cple_age_growth = J(Time_length,1,0) 
bop_multif_age_growth = J(Time_length,1,0)  

tar_onep_age_growth = J(Time_length,1,0) 
tar_twop_age_growth = J(Time_length,1,0) 
tar_alon_age_growth = J(Time_length,1,0) 
tar_mult_age_growth = J(Time_length,1,0) 
tar_cple_age_growth = J(Time_length,1,0) 
tar_multif_age_growth = J(Time_length,1,0)  

man_onep_age_growth = J(Time_length,1,0) 
man_twop_age_growth = J(Time_length,1,0) 
man_alon_age_growth = J(Time_length,1,0) 
man_mult_age_growth = J(Time_length,1,0) 
man_cple_age_growth = J(Time_length,1,0) 
man_multif_age_growth = J(Time_length,1,0)  

wel_onep_age_growth = J(Time_length,1,0) 
wel_twop_age_growth = J(Time_length,1,0) 
wel_alon_age_growth = J(Time_length,1,0) 
wel_mult_age_growth = J(Time_length,1,0) 
wel_cple_age_growth = J(Time_length,1,0) 
wel_multif_age_growth = J(Time_length,1,0)  

can_onep_age_growth = J(Time_length,1,0) 
can_twop_age_growth = J(Time_length,1,0) 
can_alon_age_growth = J(Time_length,1,0) 
can_mult_age_growth = J(Time_length,1,0) 
can_cple_age_growth = J(Time_length,1,0) 
can_multif_age_growth = J(Time_length,1,0)  

otg_onep_age_growth = J(Time_length,1,0) 
otg_twop_age_growth = J(Time_length,1,0) 
otg_alon_age_growth = J(Time_length,1,0) 
otg_mult_age_growth = J(Time_length,1,0) 
otg_cple_age_growth = J(Time_length,1,0) 
otg_multif_age_growth = J(Time_length,1,0)  

sth_onep_age_growth = J(Time_length,1,0) 
sth_twop_age_growth = J(Time_length,1,0) 
sth_alon_age_growth = J(Time_length,1,0) 
sth_mult_age_growth = J(Time_length,1,0) 
sth_cple_age_growth = J(Time_length,1,0) 
sth_multif_age_growth = J(Time_length,1,0)  

gis_onep_age_growth = J(Time_length,1,0) 
gis_twop_age_growth = J(Time_length,1,0) 
gis_alon_age_growth = J(Time_length,1,0) 
gis_mult_age_growth = J(Time_length,1,0) 
gis_cple_age_growth = J(Time_length,1,0) 
gis_multif_age_growth = J(Time_length,1,0)  

usi_onep_age_growth = J(Time_length,1,0) 
usi_twop_age_growth = J(Time_length,1,0) 
usi_alon_age_growth = J(Time_length,1,0) 
usi_mult_age_growth = J(Time_length,1,0) 
usi_cple_age_growth = J(Time_length,1,0) 
usi_multif_age_growth = J(Time_length,1,0)  
}



{
nor_netmigration_fcast=J(Time_length,Ages_n,1)
akl_netmigration_fcast=J(Time_length,Ages_n,1) 
wai_netmigration_fcast=J(Time_length,Ages_n,1) 
bop_netmigration_fcast=J(Time_length,Ages_n,1) 
tar_netmigration_fcast=J(Time_length,Ages_n,1) 
man_netmigration_fcast=J(Time_length,Ages_n,1) 
wel_netmigration_fcast=J(Time_length,Ages_n,1) 
can_netmigration_fcast=J(Time_length,Ages_n,1) 
otg_netmigration_fcast=J(Time_length,Ages_n,1) 
sth_netmigration_fcast=J(Time_length,Ages_n,1) 
gis_netmigration_fcast=J(Time_length,Ages_n,1) 
usi_netmigration_fcast=J(Time_length,Ages_n,1)

nor_emigr_f = J(Time_length,Ages_n,0)
akl_emigr_f = J(Time_length,Ages_n,0)
wai_emigr_f = J(Time_length,Ages_n,0)
bop_emigr_f = J(Time_length,Ages_n,0)
tar_emigr_f = J(Time_length,Ages_n,0)
man_emigr_f = J(Time_length,Ages_n,0)
wel_emigr_f = J(Time_length,Ages_n,0)
can_emigr_f = J(Time_length,Ages_n,0)
otg_emigr_f = J(Time_length,Ages_n,0)
sth_emigr_f = J(Time_length,Ages_n,0)
gis_emigr_f = J(Time_length,Ages_n,0)
usi_emigr_f = J(Time_length,Ages_n,0)

nor_emigr_m = J(Time_length,Ages_n,0)
akl_emigr_m = J(Time_length,Ages_n,0)
wai_emigr_m = J(Time_length,Ages_n,0)
bop_emigr_m = J(Time_length,Ages_n,0)
tar_emigr_m = J(Time_length,Ages_n,0)
man_emigr_m = J(Time_length,Ages_n,0)
wel_emigr_m = J(Time_length,Ages_n,0)
can_emigr_m = J(Time_length,Ages_n,0)
otg_emigr_m = J(Time_length,Ages_n,0)
sth_emigr_m = J(Time_length,Ages_n,0)
gis_emigr_m = J(Time_length,Ages_n,0)
usi_emigr_m = J(Time_length,Ages_n,0)
}

os_emigr_f = J(Time_length,Ages_n,0)
os_emigr_m = J(Time_length,Ages_n,0)
os_emigr_fcast = J(Time_length,Ages_n,0)

{
nor_immigr_f = J(Time_length,Ages_n,0)
akl_immigr_f = J(Time_length,Ages_n,0)
wai_immigr_f = J(Time_length,Ages_n,0)
bop_immigr_f = J(Time_length,Ages_n,0)
tar_immigr_f = J(Time_length,Ages_n,0)
man_immigr_f = J(Time_length,Ages_n,0)
wel_immigr_f = J(Time_length,Ages_n,0)
can_immigr_f = J(Time_length,Ages_n,0)
otg_immigr_f = J(Time_length,Ages_n,0)
sth_immigr_f = J(Time_length,Ages_n,0)
gis_immigr_f = J(Time_length,Ages_n,0)
usi_immigr_f = J(Time_length,Ages_n,0)

nor_immigr_m = J(Time_length,Ages_n,0)
akl_immigr_m = J(Time_length,Ages_n,0)
wai_immigr_m = J(Time_length,Ages_n,0)
bop_immigr_m = J(Time_length,Ages_n,0)
tar_immigr_m = J(Time_length,Ages_n,0)
man_immigr_m = J(Time_length,Ages_n,0)
wel_immigr_m = J(Time_length,Ages_n,0)
can_immigr_m = J(Time_length,Ages_n,0)
otg_immigr_m = J(Time_length,Ages_n,0)
sth_immigr_m = J(Time_length,Ages_n,0)
gis_immigr_m = J(Time_length,Ages_n,0)
usi_immigr_m = J(Time_length,Ages_n,0)

nor_netm_f = J(Time_length,Ages_n,0)
akl_netm_f = J(Time_length,Ages_n,0)
wai_netm_f = J(Time_length,Ages_n,0)
bop_netm_f = J(Time_length,Ages_n,0)
tar_netm_f = J(Time_length,Ages_n,0)
man_netm_f = J(Time_length,Ages_n,0)
wel_netm_f = J(Time_length,Ages_n,0)
can_netm_f = J(Time_length,Ages_n,0)
otg_netm_f = J(Time_length,Ages_n,0)
sth_netm_f = J(Time_length,Ages_n,0)
gis_netm_f = J(Time_length,Ages_n,0)
usi_netm_f = J(Time_length,Ages_n,0)

nor_netm_m = J(Time_length,Ages_n,0)
akl_netm_m = J(Time_length,Ages_n,0)
wai_netm_m = J(Time_length,Ages_n,0)
bop_netm_m = J(Time_length,Ages_n,0)
tar_netm_m = J(Time_length,Ages_n,0)
man_netm_m = J(Time_length,Ages_n,0)
wel_netm_m = J(Time_length,Ages_n,0)
can_netm_m = J(Time_length,Ages_n,0)
otg_netm_m = J(Time_length,Ages_n,0)
sth_netm_m = J(Time_length,Ages_n,0)
gis_netm_m = J(Time_length,Ages_n,0)
usi_netm_m = J(Time_length,Ages_n,0)
}


mata
immigr_fcast = (immigr\ J(Projection_length,1,0))
os_emigr_fcast = (os_emigr\ J(Projection_length,Ages_n,0))
os_emigr_fcast_chk = (os_emigr\ J(Projection_length,Ages_n,0))
immigr_trnd = (immigr\J(Projection_length,1,0))
end

//for(r=1; r<=length(Reg_n); r++){
	//p = crexternal(sprintf("intl_immigr_reg_f_%f", r))
	//*p = J(Time_length,Ages_n,0)
	//p = crexternal(sprintf("intl_immigr_reg_m_%f", r))
	//*p = J(Time_length,Ages_n,0)
//}

/*Population time series with region and age composition for each year
//Net migration time series with region and age composition for each year*/
mata



/*used to help migration flows map to what we observe between regions where total labour (LEED) flows show total migration around 1.8 x census however it is unclear if the LEED data overcounts. This adjustment ensures that the age-based model matches with what we observe for outward migration - this could be revisited*/
p_emigr_adjust = 1.1

p_emigr_t =J(Time_length,1,p_emigr:*p_emigr_adjust)
/*p_emigr_t = repmat(p_emigr:*p_emigr_adjust,[1 1 Time_length])*/

reg_pop_f_t_res = J(Time_length*Ages_n,Regl,0)
reg_pop_m_t_res = J(Time_length*Ages_n,Regl,0)
netm_f_t = J(Time_length,Regl,0)
netm_m_t = J(Time_length,Regl,0)
reg_pop_f_t = J(Time_length,Regl,0)
reg_pop_m_t = J(Time_length,Regl,0)

for (r=1; r<=length(Reg_n); r++) {
	reg_pop_f_t_res[.,r] = vec(reg_pop_hist_f[((r-1)*HL+1)..(HL*r),.]\ J(Projection_length,Ages_n,0))
	reg_pop_m_t_res[.,r] = vec(reg_pop_hist_m[((r-1)*HL+1)..(HL*r),.]\ J(Projection_length,Ages_n,0))

}

/*reg_pop_hist_f = (reg_pop_hist_f[]\ J(Projection_length,Ages_n,0))*/




/*ASSUMPTIONS*/

/*LR unemployment*/
/*Unemployment*/
reg_lr_unemployment_rate = (0.082, 0.0545, 0.058, 0.0709375, 0.0534375, 0.0565625, 0.0511875, 0.0501875, 0.0499375, 0.0416875, 0.06675, 0.04125)
reg_lr_unemployment_adjspeed = 4

/*MIGRATION FORECAST*/

/* IMMIGRATION forecast*/

/*Stochastic Parameters (parameter asumptions are in main model script*/
/* mode=1 */
/*standard deviation from a VEC model of arrivals, departures and GDE per capita (previous value from detrended series 0.116482)*/

immigr_stdev = immigr_stdev_param 

immigr_e = rnormal(Projection_length,1,0,immigr_stdev):*mode
/*Trend*/
immigr_g = immigr_g_param 
immigr_growth = (J(Projection_length,1,1)':*(1:+((immigr_g-1):/migr_nonlin)))+immigr_e'
immigr_trnd_growth = (J(Projection_length,1,1)':*(1:+((immigr_g-1):/migr_nonlin)))

for (i=1; i<=Projection_length; i++) {
	    immigr_trnd[History_length+i] = immigr_trnd[History_length+i-1]:*immigr_trnd_growth[i]
		immigr_fcast[History_length+i] = immigr_fcast[History_length+i-1]:*immigr_growth[i]

intl_immigr_reg_f_res= J(Ages_n*Time_length, Regl,0)
intl_immigr_reg_m_res= J(Ages_n*Time_length, Regl,0)
}
for (r=1; r<=length(Reg_n); r++) {
	intl_immigr_reg_f_res[.,r] = vec(reg_pop_hist_f[((r-1)*HL+1)..(HL*r),.]\ J(Projection_length,Ages_n,0))
	intl_immigr_reg_m_res[.,r] = vec(reg_pop_hist_m[((r-1)*HL+1)..(HL*r),.]\ J(Projection_length,Ages_n,0))

}			
			
			

/* Note that the history is not accurate as the age_dist is fixed*/

immigr_age = round(immigr_fcast*immigr_agedist) 
immigr_age_f = round(immigr_age:/2)
immigr_age_m = round(immigr_age:/2)


intl_immigr_reg_f_1 = round(J(Time_length, 1, immigr_regdist[1,.]):*immigr_age_f)
intl_immigr_reg_f_2 = round(J(Time_length, 1, immigr_regdist[2,.]):*immigr_age_f)
intl_immigr_reg_f_3 = round(J(Time_length, 1, immigr_regdist[3,.]):*immigr_age_f)
intl_immigr_reg_f_4 = round(J(Time_length, 1, immigr_regdist[4,.]):*immigr_age_f)
intl_immigr_reg_f_5 = round(J(Time_length, 1, immigr_regdist[5,.]):*immigr_age_f)
intl_immigr_reg_f_6 = round(J(Time_length, 1, immigr_regdist[6,.]):*immigr_age_f)
intl_immigr_reg_f_7 = round(J(Time_length, 1, immigr_regdist[7,.]):*immigr_age_f)
intl_immigr_reg_f_8 = round(J(Time_length, 1, immigr_regdist[8,.]):*immigr_age_f)
intl_immigr_reg_f_9 = round(J(Time_length, 1, immigr_regdist[9,.]):*immigr_age_f)
intl_immigr_reg_f_10 = round(J(Time_length, 1, immigr_regdist[10,.]):*immigr_age_f)
intl_immigr_reg_f_11 = round(J(Time_length, 1, immigr_regdist[11,.]):*immigr_age_f)
intl_immigr_reg_f_12 = round(J(Time_length, 1, immigr_regdist[12,.]):*immigr_age_f)

intl_immigr_reg_m_1 = round(J(Time_length, 1, immigr_regdist[1,.]):*immigr_age_m)
intl_immigr_reg_m_2 = round(J(Time_length, 1, immigr_regdist[2,.]):*immigr_age_m)
intl_immigr_reg_m_3 = round(J(Time_length, 1, immigr_regdist[3,.]):*immigr_age_m)
intl_immigr_reg_m_4 = round(J(Time_length, 1, immigr_regdist[4,.]):*immigr_age_m)
intl_immigr_reg_m_5 = round(J(Time_length, 1, immigr_regdist[5,.]):*immigr_age_m)
intl_immigr_reg_m_6 = round(J(Time_length, 1, immigr_regdist[6,.]):*immigr_age_m)
intl_immigr_reg_m_7 = round(J(Time_length, 1, immigr_regdist[7,.]):*immigr_age_m)
intl_immigr_reg_m_8 = round(J(Time_length, 1, immigr_regdist[8,.]):*immigr_age_m)
intl_immigr_reg_m_9 = round(J(Time_length, 1, immigr_regdist[9,.]):*immigr_age_m)
intl_immigr_reg_m_10 = round(J(Time_length, 1, immigr_regdist[10,.]):*immigr_age_m)
intl_immigr_reg_m_11 = round(J(Time_length, 1, immigr_regdist[11,.]):*immigr_age_m)
intl_immigr_reg_m_12 = round(J(Time_length, 1, immigr_regdist[12,.]):*immigr_age_m)

/*standard deviation from a VEC model of arrivals, departures and GDE per capita (previous value from detrended series 0.134929)*/
p_emigr_stdev = p_emigr_stdev_param 
p_emigr_e = rnormal(Time_length,1,0,p_emigr_stdev):*mode + p_emigr_cyc'
p_emigr_g = p_emigr_g_param
p_emigr_growth = (J(Time_length,1,1)':*p_emigr_g)+p_emigr_e'


/* HERE WE HAVE A 58 COL MATRIX OF P_EMIGR_GROWTH THAT NEEDS TO BE APPLIED TO 
/// THE (101X58)X12 MATRIX OF P_EMIGR_T
/// NOTE THAT NOW THE P_EMIGR_T ROWS ARE 59X101 AND COLS ARE REGIONS*/
p_emigr_growth_rep0 =J(1,Ages_n,p_emigr_growth')
p_emigr_growth_rep = vec(p_emigr_growth_rep0')
p_emigr_t = p_emigr_t:*p_emigr_growth_rep


/* Regional netmigration scenario inputs - values and calculated distribution

//Labour force*/
reg_lfpr_fcast = (reg_lfpr_input\ J(Projection_length, Regl,0))
reg_unemployment_fcast_rate = (reg_unemp_input\ J(Projection_length, Regl, 0))
reg_lf_growth = J(Time_length, Regl,0)
reg_employment_growth =J(Time_length, Regl, 0)

/*The assumption here is taken from Grimes et al 2007 "A 1// region-specific */employment shock raises the long-run regional*/
/*share of employment by 0.5 percentage points, due entirely to*/
/*in-migration." */


/*Data variables mutlif_onep and mutif_twop are the assumed and historical*/
/*proportions of one parent and two parent families in multi-family*/
/*households*/

/* REGIONAL AGE AND SEX SPECIFIC POP PROJECTIONS*/
/* AGE AND SEX SPECIFIC FORECAST METHOD*/
/*(Leslie matrix based population forecast. Assumes age specific survival probabilities*/
/*and fertility are the same for all regions - thus regional population*/
/*forecasts are solely a function of pre-existing age structures*/

/*Global parameters (development could make these region specific*/
/*Create diagonal matrix of female survival probabilities (p_f)*/
/*Create female transition matrix*/

for (i=2; i<=Projection_length; i++) {
	
	p_f=diag(survival_f[i,.]) 
	T_f=(fertility_rate[i,.]\ p_f[1..k_minus_one,.] )
	p_m=diag(survival_m[i,.]) 
	T_m=(fertility_rate[i,.]*male_fertility\ p_m[1..k_minus_one,.])	

}
end
mata
/*Regional forecasts*/

/*Shocks to inward migration via emigr_dest*/
p_emigr_dest =  J(rows(p_emigr_dest),1,immigr_shk):*p_emigr_dest
p_emigr_dest = p_emigr_dest:/J(1,cols(p_emigr_dest),rowsum(p_emigr_dest))
/*Global parameters (development could make these region specific) ALSO -*/
/*development needs to remove inconsistency in time periods betwwn*/
/*primitives (survival etc and other components)*/

/*Create diagonal matrix of female survival probabilities (p_f)*/
/*Create female transition matrix*/
/*Create diagonal matrix of male survival probabilities (p_m)*/
/*Create male transition matrix: note zero in male births*/

/*NOR*/
/*Initial forecast of births and female mortality*/
/* Forecast male nor_population based on aging and survival*/
/* Allocate male births to male population*/
/* Subtract male births from female population*/
/*Add migration*/
/*Add migration based on forecast aggregate and historical age and sex distributions*/

all_pop_fcast_f = (vec(nor_pop_fcast_f'), vec(akl_pop_fcast_f'), vec(wai_pop_fcast_f'), vec(bop_pop_fcast_f'), vec(tar_pop_fcast_f'), vec(man_pop_fcast_f'), vec(wel_pop_fcast_f'), vec(can_pop_fcast_f'), vec(otg_pop_fcast_f'), vec(sth_pop_fcast_f'), vec(gis_pop_fcast_f'), vec(usi_pop_fcast_f'))





/*Main reason for decreasing population are the emigration trends - (akl_emigr_f) for example.*/
/*Note the addition of 1 to AKL's fertility rate. This needs to be revised in the future*/
mata
for (i=HL; i<Time_length; i++){
	p_f=diag(survival_f[i-19,.])
	T_f=(fertility_rate[i-19,.]\ p_f[1..k_minus_one,.]) 
	p_m=diag(survival_m[i-19,.])
	T_m=(fertility_rate[i-19,.]*male_fertility\p_m[1..k_minus_one,.])

nor_pop_fcast_f[i+1,.]=((T_f:*(fert_adj[1,.]\ J(k_minus_one, cols(p_f),1)))*nor_pop_fcast_f[i,.]')'



nor_pop_fcast_m[i+1,.]=(T_m*nor_pop_fcast_m[i,.]')'

nor_pop_fcast_m[i+1,1]=births_sex_ratio[1,1]*nor_pop_fcast_f[i+1,1]
nor_pop_fcast_f[i+1,1]=births_sex_ratio[1,2]*nor_pop_fcast_f[i+1,1]


nor_emigr_f[i+1,.]= p_emigr_t[(Ages_n*(i)+1)..Ages_n*(i+1),1]':*nor_pop_fcast_f[i,.]
nor_emigr_m[i+1,.]= p_emigr_t[(Ages_n*(i)+1)..Ages_n*(i+1),1]':*nor_pop_fcast_m[i,.]

nor_immigr_f[i+1,.]=(round(rowsum(rowshape(p_emigr_dest[.,1]:*vec(p_emigr_t[((i)*Ages_n+1)..Ages_n*(i+1),.]':*reg_pop_f_t_res[((i-1)*Ages_n+1)..Ages_n*(i),.]'),Ages_n)), 1))'

nor_immigr_m[i+1,.]=(round(rowsum(rowshape(p_emigr_dest[.,1]:*vec(p_emigr_t[((i)*Ages_n+1)..Ages_n*(i+1),.]':*reg_pop_m_t_res[((i-1)*Ages_n+1)..Ages_n*(i),.]'),Ages_n)), 1))'

nor_netm_f[i+1,.] = nor_immigr_f[i+1,.]+intl_immigr_reg_f_1[i+1,.]-nor_emigr_f[i+1,.]
nor_netm_m[i+1,.] = nor_immigr_m[i+1,.]+intl_immigr_reg_m_1[i+1,.]-nor_emigr_m[i+1,.]

nor_pop_fcast_m[i+1,.]= nor_pop_fcast_m[i+1,.]+ nor_netm_m[i+1,.]
nor_pop_fcast_f[i+1,.]= nor_pop_fcast_f[i+1,.]+ nor_netm_f[i+1,.]


akl_pop_fcast_f[i+1,.]=((T_f:*((fert_adj[2,.]:+1)\ J(k_minus_one, cols(p_f),1)))*akl_pop_fcast_f[i,.]')'
akl_pop_fcast_m[i+1,.]=(T_m*akl_pop_fcast_m[i,.]')'

akl_pop_fcast_m[i+1,1]=births_sex_ratio[1,1]*akl_pop_fcast_f[i+1,1]
akl_pop_fcast_f[i+1,1]=births_sex_ratio[1,2]*akl_pop_fcast_f[i+1,1]

akl_emigr_f[i+1,.]= p_emigr_t[(Ages_n*(i)+1)..Ages_n*(i+1),2]':*akl_pop_fcast_f[i,.]
akl_emigr_m[i+1,.]= p_emigr_t[(Ages_n*(i)+1)..Ages_n*(i+1),2]':*akl_pop_fcast_m[i,.]

akl_immigr_f[i+1,.]=(round(rowsum(rowshape(p_emigr_dest[.,2]:*vec(p_emigr_t[((i)*Ages_n+1)..Ages_n*(i+1),.]':*reg_pop_f_t_res[((i-1)*Ages_n+1)..Ages_n*(i),.]'),Ages_n)), 1))'
akl_immigr_m[i+1,.]=(round(rowsum(rowshape(p_emigr_dest[.,2]:*vec(p_emigr_t[((i)*Ages_n+1)..Ages_n*(i+1),.]':*reg_pop_m_t_res[((i-1)*Ages_n+1)..Ages_n*(i),.]'),Ages_n)), 1))'

akl_netm_f[i+1,.] = akl_immigr_f[i+1,.]+intl_immigr_reg_f_2[i+1,.]-akl_emigr_f[i+1,.]
akl_netm_m[i+1,.] = akl_immigr_m[i+1,.]+intl_immigr_reg_m_2[i+1,.]-akl_emigr_m[i+1,.]

akl_pop_fcast_m[i+1,.]= akl_pop_fcast_m[i+1,.]+ akl_netm_m[i+1,.]
akl_pop_fcast_f[i+1,.]= akl_pop_fcast_f[i+1,.]+ akl_netm_f[i+1,.]

wai_pop_fcast_f[i+1,.]=((T_f:*(fert_adj[3,.]\ J(k_minus_one, cols(p_f),1)))*wai_pop_fcast_f[i,.]')'
wai_pop_fcast_m[i+1,.]=(T_m*wai_pop_fcast_m[i,.]')'

wai_pop_fcast_m[i+1,1]=births_sex_ratio[1,1]*wai_pop_fcast_f[i+1,1]
wai_pop_fcast_f[i+1,1]=births_sex_ratio[1,2]*wai_pop_fcast_f[i+1,1]

wai_emigr_f[i+1,.]= p_emigr_t[(Ages_n*(i)+1)..Ages_n*(i+1),3]':*wai_pop_fcast_f[i,.]
wai_emigr_m[i+1,.]= p_emigr_t[(Ages_n*(i)+1)..Ages_n*(i+1),3]':*wai_pop_fcast_m[i,.]

wai_immigr_f[i+1,.]=(round(rowsum(rowshape(p_emigr_dest[.,3]:*vec(p_emigr_t[((i)*Ages_n+1)..Ages_n*(i+1),.]':*reg_pop_f_t_res[((i-1)*Ages_n+1)..Ages_n*(i),.]'),Ages_n)), 1))'
wai_immigr_m[i+1,.]=(round(rowsum(rowshape(p_emigr_dest[.,3]:*vec(p_emigr_t[((i)*Ages_n+1)..Ages_n*(i+1),.]':*reg_pop_m_t_res[((i-1)*Ages_n+1)..Ages_n*(i),.]'),Ages_n)), 1))'

wai_netm_f[i+1,.] = wai_immigr_f[i+1,.]+intl_immigr_reg_f_3[i+1,.]-wai_emigr_f[i+1,.]
wai_netm_m[i+1,.] = wai_immigr_m[i+1,.]+intl_immigr_reg_m_3[i+1,.]-wai_emigr_m[i+1,.]

wai_pop_fcast_m[i+1,.]= wai_pop_fcast_m[i+1,.]+ wai_netm_m[i+1,.]
wai_pop_fcast_f[i+1,.]= wai_pop_fcast_f[i+1,.]+ wai_netm_f[i+1,.]


bop_pop_fcast_f[i+1,.]=((T_f:*(fert_adj[4,.]\ J(k_minus_one, cols(p_f),1)))*bop_pop_fcast_f[i,.]')'
bop_pop_fcast_m[i+1,.]=(T_m*bop_pop_fcast_m[i,.]')'

bop_pop_fcast_m[i+1,1]=births_sex_ratio[1,1]*bop_pop_fcast_f[i+1,1]
bop_pop_fcast_f[i+1,1]=births_sex_ratio[1,2]*bop_pop_fcast_f[i+1,1]

bop_emigr_f[i+1,.]= p_emigr_t[(Ages_n*(i)+1)..Ages_n*(i+1),4]':*bop_pop_fcast_f[i,.]
bop_emigr_m[i+1,.]= p_emigr_t[(Ages_n*(i)+1)..Ages_n*(i+1),4]':*bop_pop_fcast_m[i,.]

bop_immigr_f[i+1,.]=(round(rowsum(rowshape(p_emigr_dest[.,4]:*vec(p_emigr_t[((i)*Ages_n+1)..Ages_n*(i+1),.]':*reg_pop_f_t_res[((i-1)*Ages_n+1)..Ages_n*(i),.]'),Ages_n)), 1))'
bop_immigr_m[i+1,.]=(round(rowsum(rowshape(p_emigr_dest[.,4]:*vec(p_emigr_t[((i)*Ages_n+1)..Ages_n*(i+1),.]':*reg_pop_m_t_res[((i-1)*Ages_n+1)..Ages_n*(i),.]'),Ages_n)), 1))'

bop_netm_f[i+1,.] = bop_immigr_f[i+1,.]+intl_immigr_reg_f_4[i+1,.]-bop_emigr_f[i+1,.]
bop_netm_m[i+1,.] = bop_immigr_m[i+1,.]+intl_immigr_reg_m_4[i+1,.]-bop_emigr_m[i+1,.]

bop_pop_fcast_m[i+1,.]= bop_pop_fcast_m[i+1,.]+ bop_netm_m[i+1,.]
bop_pop_fcast_f[i+1,.]= bop_pop_fcast_f[i+1,.]+ bop_netm_f[i+1,.]

tar_pop_fcast_f[i+1,.]=((T_f:*(fert_adj[5,.]\ J(k_minus_one, cols(p_f),1)))*tar_pop_fcast_f[i,.]')'
tar_pop_fcast_m[i+1,.]=(T_m*tar_pop_fcast_m[i,.]')'

tar_pop_fcast_m[i+1,1]=births_sex_ratio[1,1]*tar_pop_fcast_f[i+1,1]
tar_pop_fcast_f[i+1,1]=births_sex_ratio[1,2]*tar_pop_fcast_f[i+1,1]

tar_emigr_f[i+1,.]= p_emigr_t[(Ages_n*(i)+1)..Ages_n*(i+1),5]':*tar_pop_fcast_f[i,.]
tar_emigr_m[i+1,.]= p_emigr_t[(Ages_n*(i)+1)..Ages_n*(i+1),5]':*tar_pop_fcast_m[i,.]

tar_immigr_f[i+1,.]=(round(rowsum(rowshape(p_emigr_dest[.,5]:*vec(p_emigr_t[((i)*Ages_n+1)..Ages_n*(i+1),.]':*reg_pop_f_t_res[((i-1)*Ages_n+1)..Ages_n*(i),.]'),Ages_n)), 1))'
tar_immigr_m[i+1,.]=(round(rowsum(rowshape(p_emigr_dest[.,5]:*vec(p_emigr_t[((i)*Ages_n+1)..Ages_n*(i+1),.]':*reg_pop_m_t_res[((i-1)*Ages_n+1)..Ages_n*(i),.]'),Ages_n)), 1))'

tar_netm_f[i+1,.] = tar_immigr_f[i+1,.]+intl_immigr_reg_f_5[i+1,.]-tar_emigr_f[i+1,.]
tar_netm_m[i+1,.] = tar_immigr_m[i+1,.]+intl_immigr_reg_m_5[i+1,.]-tar_emigr_m[i+1,.]

tar_pop_fcast_m[i+1,.]= tar_pop_fcast_m[i+1,.]+ tar_netm_m[i+1,.]
tar_pop_fcast_f[i+1,.]= tar_pop_fcast_f[i+1,.]+ tar_netm_f[i+1,.]


man_pop_fcast_f[i+1,.]=((T_f:*(fert_adj[6,.]\ J(k_minus_one, cols(p_f),1)))*man_pop_fcast_f[i,.]')'
man_pop_fcast_m[i+1,.]=(T_m*man_pop_fcast_m[i,.]')'

man_pop_fcast_m[i+1,1]=births_sex_ratio[1,1]*man_pop_fcast_f[i+1,1]
man_pop_fcast_f[i+1,1]=births_sex_ratio[1,2]*man_pop_fcast_f[i+1,1]

man_emigr_f[i+1,.]= p_emigr_t[(Ages_n*(i)+1)..Ages_n*(i+1),6]':*man_pop_fcast_f[i,.]
man_emigr_m[i+1,.]= p_emigr_t[(Ages_n*(i)+1)..Ages_n*(i+1),6]':*man_pop_fcast_m[i,.]

man_immigr_f[i+1,.]=(round(rowsum(rowshape(p_emigr_dest[.,6]:*vec(p_emigr_t[((i)*Ages_n+1)..Ages_n*(i+1),.]':*reg_pop_f_t_res[((i-1)*Ages_n+1)..Ages_n*(i),.]'),Ages_n)), 1))'
man_immigr_m[i+1,.]=(round(rowsum(rowshape(p_emigr_dest[.,6]:*vec(p_emigr_t[((i)*Ages_n+1)..Ages_n*(i+1),.]':*reg_pop_m_t_res[((i-1)*Ages_n+1)..Ages_n*(i),.]'),Ages_n)), 1))'

man_netm_f[i+1,.] = man_immigr_f[i+1,.]+intl_immigr_reg_f_6[i+1,.]-man_emigr_f[i+1,.]
man_netm_m[i+1,.] = man_immigr_m[i+1,.]+intl_immigr_reg_m_6[i+1,.]-man_emigr_m[i+1,.]

man_pop_fcast_m[i+1,.]= man_pop_fcast_m[i+1,.]+ man_netm_m[i+1,.]
man_pop_fcast_f[i+1,.]= man_pop_fcast_f[i+1,.]+ man_netm_f[i+1,.]


wel_pop_fcast_f[i+1,.]=((T_f:*(fert_adj[7,.]\ J(k_minus_one, cols(p_f),1)))*wel_pop_fcast_f[i,.]')'
wel_pop_fcast_m[i+1,.]=(T_m*wel_pop_fcast_m[i,.]')'

wel_pop_fcast_m[i+1,1]=births_sex_ratio[1,1]*wel_pop_fcast_f[i+1,1]
wel_pop_fcast_f[i+1,1]=births_sex_ratio[1,2]*wel_pop_fcast_f[i+1,1]

wel_emigr_f[i+1,.]= p_emigr_t[(Ages_n*(i)+1)..Ages_n*(i+1),7]':*wel_pop_fcast_f[i,.]
wel_emigr_m[i+1,.]= p_emigr_t[(Ages_n*(i)+1)..Ages_n*(i+1),7]':*wel_pop_fcast_m[i,.]

wel_immigr_f[i+1,.]=(round(rowsum(rowshape(p_emigr_dest[.,7]:*vec(p_emigr_t[((i)*Ages_n+1)..Ages_n*(i+1),.]':*reg_pop_f_t_res[((i-1)*Ages_n+1)..Ages_n*(i),.]'),Ages_n)), 1))'
wel_immigr_m[i+1,.]=(round(rowsum(rowshape(p_emigr_dest[.,7]:*vec(p_emigr_t[((i)*Ages_n+1)..Ages_n*(i+1),.]':*reg_pop_m_t_res[((i-1)*Ages_n+1)..Ages_n*(i),.]'),Ages_n)), 1))'

wel_netm_f[i+1,.] = wel_immigr_f[i+1,.]+intl_immigr_reg_f_7[i+1,.]-wel_emigr_f[i+1,.]
wel_netm_m[i+1,.] = wel_immigr_m[i+1,.]+intl_immigr_reg_m_7[i+1,.]-wel_emigr_m[i+1,.]

wel_pop_fcast_m[i+1,.]= wel_pop_fcast_m[i+1,.]+ wel_netm_m[i+1,.]
wel_pop_fcast_f[i+1,.]= wel_pop_fcast_f[i+1,.]+ wel_netm_f[i+1,.]


can_pop_fcast_f[i+1,.]=((T_f:*(fert_adj[8,.]\ J(k_minus_one, cols(p_f),1)))*can_pop_fcast_f[i,.]')'
can_pop_fcast_m[i+1,.]=(T_m*can_pop_fcast_m[i,.]')'

can_pop_fcast_m[i+1,1]=births_sex_ratio[1,1]*can_pop_fcast_f[i+1,1]
can_pop_fcast_f[i+1,1]=births_sex_ratio[1,2]*can_pop_fcast_f[i+1,1]

can_emigr_f[i+1,.]= p_emigr_t[(Ages_n*(i)+1)..Ages_n*(i+1),8]':*can_pop_fcast_f[i,.]
can_emigr_m[i+1,.]= p_emigr_t[(Ages_n*(i)+1)..Ages_n*(i+1),8]':*can_pop_fcast_m[i,.]

can_immigr_f[i+1,.]=(round(rowsum(rowshape(p_emigr_dest[.,8]:*vec(p_emigr_t[((i)*Ages_n+1)..Ages_n*(i+1),.]':*reg_pop_f_t_res[((i-1)*Ages_n+1)..Ages_n*(i),.]'),Ages_n)), 1))'
can_immigr_m[i+1,.]=(round(rowsum(rowshape(p_emigr_dest[.,8]:*vec(p_emigr_t[((i)*Ages_n+1)..Ages_n*(i+1),.]':*reg_pop_m_t_res[((i-1)*Ages_n+1)..Ages_n*(i),.]'),Ages_n)), 1))'

can_netm_f[i+1,.] = can_immigr_f[i+1,.]+intl_immigr_reg_f_8[i+1,.]-can_emigr_f[i+1,.]
can_netm_m[i+1,.] = can_immigr_m[i+1,.]+intl_immigr_reg_m_8[i+1,.]-can_emigr_m[i+1,.]

can_pop_fcast_m[i+1,.]= can_pop_fcast_m[i+1,.]+ can_netm_m[i+1,.]
can_pop_fcast_f[i+1,.]= can_pop_fcast_f[i+1,.]+ can_netm_f[i+1,.]


otg_pop_fcast_f[i+1,.]=((T_f:*(fert_adj[9,.]\ J(k_minus_one, cols(p_f),1)))*otg_pop_fcast_f[i,.]')'
otg_pop_fcast_m[i+1,.]=(T_m*otg_pop_fcast_m[i,.]')'

otg_pop_fcast_m[i+1,1]=births_sex_ratio[1,1]*otg_pop_fcast_f[i+1,1]
otg_pop_fcast_f[i+1,1]=births_sex_ratio[1,2]*otg_pop_fcast_f[i+1,1]

otg_emigr_f[i+1,.]= p_emigr_t[(Ages_n*(i)+1)..Ages_n*(i+1),9]':*otg_pop_fcast_f[i,.]
otg_emigr_m[i+1,.]= p_emigr_t[(Ages_n*(i)+1)..Ages_n*(i+1),9]':*otg_pop_fcast_m[i,.]

otg_immigr_f[i+1,.]=(round(rowsum(rowshape(p_emigr_dest[.,9]:*vec(p_emigr_t[((i)*Ages_n+1)..Ages_n*(i+1),.]':*reg_pop_f_t_res[((i-1)*Ages_n+1)..Ages_n*(i),.]'),Ages_n)), 1))'
otg_immigr_m[i+1,.]=(round(rowsum(rowshape(p_emigr_dest[.,9]:*vec(p_emigr_t[((i)*Ages_n+1)..Ages_n*(i+1),.]':*reg_pop_m_t_res[((i-1)*Ages_n+1)..Ages_n*(i),.]'),Ages_n)), 1))'

otg_netm_f[i+1,.] = otg_immigr_f[i+1,.]+intl_immigr_reg_f_9[i+1,.]-otg_emigr_f[i+1,.]
otg_netm_m[i+1,.] = otg_immigr_m[i+1,.]+intl_immigr_reg_m_9[i+1,.]-otg_emigr_m[i+1,.]

otg_pop_fcast_m[i+1,.]= otg_pop_fcast_m[i+1,.]+ otg_netm_m[i+1,.]
otg_pop_fcast_f[i+1,.]= otg_pop_fcast_f[i+1,.]+ otg_netm_f[i+1,.]


sth_pop_fcast_f[i+1,.]=((T_f:*(fert_adj[10,.]\ J(k_minus_one, cols(p_f),1)))*sth_pop_fcast_f[i,.]')'
sth_pop_fcast_m[i+1,.]=(T_m*sth_pop_fcast_m[i,.]')'

sth_pop_fcast_m[i+1,1]=births_sex_ratio[1,1]*sth_pop_fcast_f[i+1,1]
sth_pop_fcast_f[i+1,1]=births_sex_ratio[1,2]*sth_pop_fcast_f[i+1,1]

sth_emigr_f[i+1,.]= p_emigr_t[(Ages_n*(i)+1)..Ages_n*(i+1),10]':*sth_pop_fcast_f[i,.]
sth_emigr_m[i+1,.]= p_emigr_t[(Ages_n*(i)+1)..Ages_n*(i+1),10]':*sth_pop_fcast_m[i,.]

sth_immigr_f[i+1,.]=(round(rowsum(rowshape(p_emigr_dest[.,10]:*vec(p_emigr_t[((i)*Ages_n+1)..Ages_n*(i+1),.]':*reg_pop_f_t_res[((i-1)*Ages_n+1)..Ages_n*(i),.]'),Ages_n)), 1))'
sth_immigr_m[i+1,.]=(round(rowsum(rowshape(p_emigr_dest[.,10]:*vec(p_emigr_t[((i)*Ages_n+1)..Ages_n*(i+1),.]':*reg_pop_m_t_res[((i-1)*Ages_n+1)..Ages_n*(i),.]'),Ages_n)), 1))'

sth_netm_f[i+1,.] = sth_immigr_f[i+1,.]+intl_immigr_reg_f_10[i+1,.]-sth_emigr_f[i+1,.]
sth_netm_m[i+1,.] = sth_immigr_m[i+1,.]+intl_immigr_reg_m_10[i+1,.]-sth_emigr_m[i+1,.]

sth_pop_fcast_m[i+1,.]= sth_pop_fcast_m[i+1,.]+ sth_netm_m[i+1,.]
sth_pop_fcast_f[i+1,.]= sth_pop_fcast_f[i+1,.]+ sth_netm_f[i+1,.]

gis_pop_fcast_f[i+1,.]=((T_f:*(fert_adj[11,.]\ J(k_minus_one, cols(p_f),1)))*gis_pop_fcast_f[i,.]')'
gis_pop_fcast_m[i+1,.]=(T_m*gis_pop_fcast_m[i,.]')'

gis_pop_fcast_m[i+1,1]=births_sex_ratio[1,1]*gis_pop_fcast_f[i+1,1]
gis_pop_fcast_f[i+1,1]=births_sex_ratio[1,2]*gis_pop_fcast_f[i+1,1]

gis_emigr_f[i+1,.]= p_emigr_t[(Ages_n*(i)+1)..Ages_n*(i+1),11]':*gis_pop_fcast_f[i,.]
gis_emigr_m[i+1,.]= p_emigr_t[(Ages_n*(i)+1)..Ages_n*(i+1),11]':*gis_pop_fcast_m[i,.]

gis_immigr_f[i+1,.]=(round(rowsum(rowshape(p_emigr_dest[.,11]:*vec(p_emigr_t[((i)*Ages_n+1)..Ages_n*(i+1),.]':*reg_pop_f_t_res[((i-1)*Ages_n+1)..Ages_n*(i),.]'),Ages_n)), 1))'
gis_immigr_m[i+1,.]=(round(rowsum(rowshape(p_emigr_dest[.,11]:*vec(p_emigr_t[((i)*Ages_n+1)..Ages_n*(i+1),.]':*reg_pop_m_t_res[((i-1)*Ages_n+1)..Ages_n*(i),.]'),Ages_n)), 1))'

gis_netm_f[i+1,.] = gis_immigr_f[i+1,.]+intl_immigr_reg_f_11[i+1,.]-gis_emigr_f[i+1,.]
gis_netm_m[i+1,.] = gis_immigr_m[i+1,.]+intl_immigr_reg_m_11[i+1,.]-gis_emigr_m[i+1,.]

gis_pop_fcast_m[i+1,.]= gis_pop_fcast_m[i+1,.]+ gis_netm_m[i+1,.]
gis_pop_fcast_f[i+1,.]= gis_pop_fcast_f[i+1,.]+ gis_netm_f[i+1,.]


usi_pop_fcast_f[i+1,.]=((T_f:*(fert_adj[12,.]\ J(k_minus_one, cols(p_f),1)))*usi_pop_fcast_f[i,.]')'
usi_pop_fcast_m[i+1,.]=(T_m*usi_pop_fcast_m[i,.]')'

usi_pop_fcast_m[i+1,1]=births_sex_ratio[1,1]*usi_pop_fcast_f[i+1,1]
usi_pop_fcast_f[i+1,1]=births_sex_ratio[1,2]*usi_pop_fcast_f[i+1,1]

usi_emigr_f[i+1,.]= p_emigr_t[(Ages_n*(i)+1)..Ages_n*(i+1),12]':*usi_pop_fcast_f[i,.]
usi_emigr_m[i+1,.]= p_emigr_t[(Ages_n*(i)+1)..Ages_n*(i+1),12]':*usi_pop_fcast_m[i,.]

usi_immigr_f[i+1,.]=(round(rowsum(rowshape(p_emigr_dest[.,12]:*vec(p_emigr_t[((i)*Ages_n+1)..Ages_n*(i+1),.]':*reg_pop_f_t_res[((i-1)*Ages_n+1)..Ages_n*(i),.]'),Ages_n)), 1))'
usi_immigr_m[i+1,.]=(round(rowsum(rowshape(p_emigr_dest[.,12]:*vec(p_emigr_t[((i)*Ages_n+1)..Ages_n*(i+1),.]':*reg_pop_m_t_res[((i-1)*Ages_n+1)..Ages_n*(i),.]'),Ages_n)), 1))'

usi_netm_f[i+1,.] = usi_immigr_f[i+1,.]+intl_immigr_reg_f_12[i+1,.]-usi_emigr_f[i+1,.]
usi_netm_m[i+1,.] = usi_immigr_m[i+1,.]+intl_immigr_reg_m_12[i+1,.]-usi_emigr_m[i+1,.]

usi_pop_fcast_m[i+1,.]= usi_pop_fcast_m[i+1,.]+ usi_netm_m[i+1,.]
usi_pop_fcast_f[i+1,.]= usi_pop_fcast_f[i+1,.]+ usi_netm_f[i+1,.]




os_emigr_f[i+1,.]=(round(rowsum(rowshape(p_emigr_dest[.,13]:*vec((p_emigr_t[((i)*Ages_n+1)..Ages_n*(i+1),.]':*reg_pop_f_t_res[((i-1)*Ages_n+1)..Ages_n*(i),.]')'),Ages_n)), 1))'
os_emigr_m[i+1,.]=(round(rowsum(rowshape(p_emigr_dest[.,13]:*vec((p_emigr_t[((i)*Ages_n+1)..Ages_n*(i+1),.]':*reg_pop_m_t_res[((i-1)*Ages_n+1)..Ages_n*(i),.]')'),Ages_n)), 1))'

os_emigr_fcast[i+1,.] = os_emigr_f[i+1,.]+ os_emigr_m[i+1,.]

/*Note that the dimensions of reg_pop_f_t are ReglxTime_length, Ages_n*/
reg_pop_f_t_res[((i)*Ages_n+1)..Ages_n*(i+1),.] = (nor_pop_fcast_f[i+1,.]',	akl_pop_fcast_f[i+1,.]',	wai_pop_fcast_f[i+1,.]',	bop_pop_fcast_f[i+1,.]',	tar_pop_fcast_f[i+1,.]',	man_pop_fcast_f[i+1,.]',	wel_pop_fcast_f[i+1,.]',	can_pop_fcast_f[i+1,.]',	otg_pop_fcast_f[i+1,.]',	sth_pop_fcast_f[i+1,.]',	gis_pop_fcast_f[i+1,.]',	usi_pop_fcast_f[i+1,.]')
reg_pop_m_t_res[((i)*Ages_n+1)..Ages_n*(i+1),.]= (nor_pop_fcast_m[i+1,.]',	akl_pop_fcast_m[i+1,.]',	wai_pop_fcast_m[i+1,.]',	bop_pop_fcast_m[i+1,.]',	tar_pop_fcast_m[i+1,.]',	man_pop_fcast_m[i+1,.]',	wel_pop_fcast_m[i+1,.]',	can_pop_fcast_m[i+1,.]',	otg_pop_fcast_m[i+1,.]',	sth_pop_fcast_m[i+1,.]',	gis_pop_fcast_m[i+1,.]',	usi_pop_fcast_m[i+1,.]')

reg_pop_f_t[i+1,.] = (colsum(nor_pop_fcast_f[i+1,.]'),	colsum(akl_pop_fcast_f[i+1,.]'),	colsum(wai_pop_fcast_f[i+1,.]'),	colsum(bop_pop_fcast_f[i+1,.]'),	colsum(tar_pop_fcast_f[i+1,.]'),	colsum(man_pop_fcast_f[i+1,.]'),	colsum(wel_pop_fcast_f[i+1,.]'),	colsum(can_pop_fcast_f[i+1,.]'),	colsum(otg_pop_fcast_f[i+1,.]'),	colsum(sth_pop_fcast_f[i+1,.]'),	colsum(gis_pop_fcast_f[i+1,.]'),	colsum(usi_pop_fcast_f[i+1,.]'))
reg_pop_m_t[i+1,.] = (colsum(nor_pop_fcast_m[i+1,.]'),	colsum(akl_pop_fcast_m[i+1,.]'),	colsum(wai_pop_fcast_m[i+1,.]'),	colsum(bop_pop_fcast_m[i+1,.]'),	colsum(tar_pop_fcast_m[i+1,.]'),	colsum(man_pop_fcast_m[i+1,.]'),	colsum(wel_pop_fcast_m[i+1,.]'),	colsum(can_pop_fcast_m[i+1,.]'),	colsum(otg_pop_fcast_m[i+1,.]'),	colsum(sth_pop_fcast_m[i+1,.]'),	colsum(gis_pop_fcast_m[i+1,.]'),	colsum(usi_pop_fcast_m[i+1,.]'))

reg_netm_f_t= (nor_netm_f[i+1,.]',	akl_netm_f[i+1,.]',	wai_netm_f[i+1,.]',	bop_netm_f[i+1,.]',	tar_netm_f[i+1,.]',	man_netm_f[i+1,.]',	wel_netm_f[i+1,.]',	can_netm_f[i+1,.]',	otg_netm_f[i+1,.]',	sth_netm_f[i+1,.]',	gis_netm_f[i+1,.]',	usi_netm_f[i+1,.]')
reg_netm_m_t = (nor_netm_m[i+1,.]',	akl_netm_m[i+1,.]',	wai_netm_m[i+1,.]', bop_netm_m[i+1,.]',	tar_netm_m[i+1,.]',	man_netm_m[i+1,.]',	wel_netm_m[i+1,.]',	can_netm_m[i+1,.]',	otg_netm_m[i+1,.]',	sth_netm_m[i+1,.]',	gis_netm_m[i+1,.]',	usi_netm_m[i+1,.]')

netm_f_t[i+1,.] = (colsum(nor_netm_f[i+1,.]'),	colsum(akl_netm_f[i+1,.]'),	colsum(wai_netm_f[i+1,.]'),	colsum(bop_netm_f[i+1,.]'),	colsum(tar_netm_f[i+1,.]'),	colsum(man_netm_f[i+1,.]'),	colsum(wel_netm_f[i+1,.]'),	colsum(can_netm_f[i+1,.]'),	colsum(otg_netm_f[i+1,.]'),	colsum(sth_netm_f[i+1,.]'),	colsum(gis_netm_f[i+1,.]'),	colsum(usi_netm_f[i+1,.]'))
netm_m_t[i+1,.] = (colsum(nor_netm_m[i+1,.]'),	colsum(akl_netm_m[i+1,.]'),	colsum(wai_netm_m[i+1,.]'), colsum(bop_netm_m[i+1,.]'),	colsum(tar_netm_m[i+1,.]'),	colsum(man_netm_m[i+1,.]'),	colsum(wel_netm_m[i+1,.]'),	colsum(can_netm_m[i+1,.]'),	colsum(otg_netm_m[i+1,.]'),	colsum(sth_netm_m[i+1,.]'),	colsum(gis_netm_m[i+1,.]'),	colsum(usi_netm_m[i+1,.]'))

}
reg_pop_t = reg_pop_m_t + reg_pop_f_t 
reg_netm_t = reg_netm_f_t + reg_netm_m_t
pop_t = rowsum(reg_pop_m_t) + rowsum(reg_pop_f_t)
netm_t = rowsum(netm_m_t) + rowsum(netm_f_t)
end

/* NATIONAL LEVEL AGE AND SEX SPECIFIC FORECAST */
/*(Leslie matrix based population forecast. */
 /*Create diagonal matrix of female survival probabilities (p_f)*/
 /*Create female transition matrix*/
 /*Initial forecast of births and female mortality*/
 /*Create diagonal matrix of male survival probabilities (p_m) */
 /*Create male transition matrix: note zero in male births*/
 /* Forecast male population based on aging and survival*/
 /* Allocate male births to male population*/
 /* Subtract male births from female population*/
 /*Add migration based on forecast aggregate and historical age and sex distributions*/
 /*Add migration based on forecast aggregate and historical age and sex distributions*/
mata
for (i=1; i<=Projection_length; i++){
	p_f=diag(survival_f[i,.])
	T_f=(fertility_rate[i,.]\ p_f[1..k_minus_one,.])
	pop_fcast_f[i+1,.]=(T_f*pop_fcast_f[i,.]')'
p_m=diag(survival_m[i,.])
T_m=fertility_rate[i,.]*male_fertility \ p_m[1..k_minus_one,.]
pop_fcast_m[i+1,.]=(T_m*pop_fcast_m[i,.]')'
pop_fcast_m[i+1,1]=births_sex_ratio[1,1]*pop_fcast_m[i+1,1]
pop_fcast_f[i+1,1]=births_sex_ratio[1,2]*pop_fcast_f[i+1,1]

pop_fcast_m[i+1,.]= pop_fcast_m[i+1,.]+ immigr_age_m[i+HL,.] - os_emigr_m[i+HL,.]
pop_fcast_f[i+1,.]= pop_fcast_f[i+1,.]+ immigr_age_f[i+HL,.] - os_emigr_f[i+HL,.]

}

/* CALCULATE NATIONAL POPULATION AGGREGATES AND CHART*/
pop_m = (pop_hist_m[1..History_length-1,.]\ pop_fcast_m)
pop_f = (pop_hist_f[1..History_length-1,.]\ pop_fcast_f)
pop_fcast_tot= pop_fcast_m + pop_fcast_f

os_emigr_tot = rowsum(os_emigr_fcast)
netm_fcast = round(immigr_fcast-os_emigr_tot,1)

pop_tot = pop_f + pop_m
pop = rowsum(pop_tot)

/* NATIONAL POPULATION AGE RELATED AGGREGATES*/
/* Calculate working age population, working age 5 yr bands, and dependency ratios*/
pop_m_workage = rowsum(pop_m[.,16..cols(pop_m)])
pop_f_workage = rowsum(pop_f[.,16..cols(pop_f)])
pop_workage = pop_m_workage + pop_f_workage
pop_m_15to64 = rowsum(pop_m[.,16..65])
pop_f_15to64 = rowsum(pop_f[.,16..65])
pop_15to64 = pop_f_15to64 + pop_m_15to64
pop_m_ova64 = rowsum(pop_m[.,66..cols(pop_m)])
pop_f_ova64 = rowsum(pop_f[.,66..cols(pop_f)])
pop_m_unda15 = rowsum(pop_m[.,1..15])
pop_f_unda15 = rowsum(pop_f[.,1..15])
pop_ova64 = pop_m_ova64 + pop_f_ova64
pop_unda15 = pop_m_unda15 + pop_f_unda15
pop_dependent = pop_ova64 + pop_unda15
pop_dependent_ratio = pop_dependent:/pop_15to64
pop_m_15to19 = rowsum(pop_m[.,16..20])
pop_m_20to24 = rowsum(pop_m[.,21..25])
pop_m_25to29 = rowsum(pop_m[.,26..30])
pop_m_30to34 = rowsum(pop_m[.,31..35])
pop_m_35to39 = rowsum(pop_m[.,36..40])
pop_m_40to44 = rowsum(pop_m[.,41..45])
pop_m_45to49 = rowsum(pop_m[.,46..50])
pop_m_50to54 = rowsum(pop_m[.,51..55])
pop_m_55to59 = rowsum(pop_m[.,56..60])
pop_m_60to64 = rowsum(pop_m[.,61..65])
pop_f_15to19 = rowsum(pop_f[.,16..20])
pop_f_20to24 = rowsum(pop_f[.,21..25])
pop_f_25to29 = rowsum(pop_f[.,26..30])
pop_f_30to34 = rowsum(pop_f[.,31..35])
pop_f_35to39 = rowsum(pop_f[.,36..40])
pop_f_40to44 = rowsum(pop_f[.,41..45])
pop_f_45to49 = rowsum(pop_f[.,46..50])
pop_f_50to54 = rowsum(pop_f[.,51..55])
pop_f_55to59 = rowsum(pop_f[.,56..60])
pop_f_60to64 = rowsum(pop_f[.,61..65])
pop_m_workage_bands = (pop_m_15to19, pop_m_20to24,pop_m_25to29,pop_m_30to34,pop_m_35to39, pop_m_40to44, pop_m_45to49, pop_m_50to54, pop_m_55to59, pop_m_60to64, pop_m_ova64)
pop_f_workage_bands = (pop_f_15to19, pop_f_20to24,pop_f_25to29,pop_f_30to34,pop_f_35to39, pop_f_40to44, pop_f_45to49, pop_f_50to54, pop_f_55to59, pop_f_60to64, pop_f_ova64)
pop_workage_bands = pop_m_workage_bands + pop_f_workage_bands
/*Calculate average age of the population*/
pop_ave_age = (pop_tot*Ages'):/pop

/* PROJECT NATIONAL HOUSEHOLDS.. POPULATION BY LIVING ARRANGEMENT*/


/*(i) first for each category of person and gender*/
f_onep_c = pop_f:*LATR_f[1..TL,.]
f_twop_c = pop_f:*LATR_f[1+TL*1..TL+TL*1,.]
f_alon_a = pop_f:*LATR_f[1+TL*2..TL+TL*2,.]
f_mult_o = pop_f:*LATR_f[1+TL*3..TL+TL*3,.]
f_cple_o = pop_f:*LATR_f[1+TL*4..TL+TL*4,.]
f_onep_o = pop_f:*LATR_f[1+TL*5..TL+TL*5,.]
f_twop_o = pop_f:*LATR_f[1+TL*6..TL+TL*6,.]
f_onep_a = pop_f:*LATR_f[1+TL*7..TL+TL*7,.]
f_cple_a = pop_f:*LATR_f[1+TL*8..TL+TL*8,.]
f_twop_a = pop_f:*LATR_f[1+TL*9..TL+TL*9,.]
f_nonprv = pop_f:*LATR_f[1+TL*10..TL+TL*10,.]
m_onep_c = pop_m:*LATR_m[1..TL,.]
m_twop_c = pop_m:*LATR_m[1+TL*1..TL+TL*1,.]
m_alon_a = pop_m:*LATR_m[1+TL*2..TL+TL*2,.]
m_mult_o = pop_m:*LATR_m[1+TL*3..TL+TL*3,.]
m_cple_o = pop_m:*LATR_m[1+TL*4..TL+TL*4,.]
m_onep_o = pop_m:*LATR_m[1+TL*5..TL+TL*5,.]
m_twop_o = pop_m:*LATR_m[1+TL*6..TL+TL*6,.]
m_onep_a = pop_m:*LATR_m[1+TL*7..TL+TL*7,.]
m_cple_a = pop_m:*LATR_m[1+TL*8..TL+TL*8,.]
m_twop_a = pop_m:*LATR_m[1+TL*9..TL+TL*9,.]
m_nonprv = pop_m:*LATR_m[1+TL*10..TL+TL*10,.]

/*(ii) then aggregating over gender*/
onep_c = f_onep_c + m_onep_c
twop_c = f_twop_c + m_twop_c
alon_a = f_alon_a + m_alon_a
mult_o = f_mult_o + m_mult_o
cple_o = f_cple_o + m_cple_o
onep_o = f_onep_o + m_onep_o 
twop_o = f_twop_o + m_twop_o  
onep_a = f_onep_a + m_onep_a 
cple_a = f_cple_a + m_cple_a
twop_a = f_twop_a + m_twop_a 
nonprv = f_nonprv + m_nonprv 

/* (iii) then summing over family types to give number of people, by age, in each living arrangement/family type*/
onep_all = onep_c + onep_a + onep_o
twop_all = twop_c + twop_a + twop_o
alon_all = alon_a
mult_all = mult_o
cple_all = cple_a + cple_o
families = round(rowsum(onep_a)+ rowsum(cple_a)*0.5 + rowsum(twop_a)*0.5,1)


/*Household numbers*/
onep = (1:-multif_onep):*(rowsum(onep_a)) 
twop = (1:-multif_twop):*(rowsum(twop_a):*0.5) 
onep_number_in_m = (multif_onep):*(rowsum(onep_a))
twop_number_in_m = ((multif_twop):*(rowsum(twop_a)*0.5))
multif = onep_number_in_m + twop_number_in_m 
cple = rowsum(cple_a)*0.5
alon = rowsum(alon_a) 
multi = rowsum(mult_o):/people_per_multi 
nonhh = rowsum(nonprv) 


/*Household aggregates*/
households_aggr = families:/fam_per_hh + rowsum(mult_o):/people_per_multi + rowsum(alon_a) 
households = (onep + twop + alon + multif + cple + multi) 
people_per_hh = (pop-nonhh):/households
people_per_onep = (rowsum(onep_c) + rowsum(onep_a) + rowsum(onep_o)):/rowsum(onep_a)
people_per_twop = (rowsum(twop_c) + rowsum(twop_a) + rowsum(twop_o)):/(rowsum(twop_a)*0.5)
people_per_cple = (rowsum(cple_a) + rowsum(cple_o)):/cple
people_per_multif =  (((multif_onep):*(rowsum(onep_a)+rowsum(onep_c)+rowsum(onep_o))) + ((multif_twop):*(rowsum(twop_a)+rowsum(twop_c)+rowsum(twop_o)))):/multif
people_per_alon = J(TL,1,1)
hh_size = (people_per_alon,people_per_onep,people_per_twop,people_per_multif,people_per_multi,people_per_cple)
hh_composition =(alon,onep,twop,multif,multi,cple)

hh_shares = hh_composition:/J(1,6,households)

pop_by_hh_composition = hh_composition:*hh_size
pop_by_hh_composition_shares = pop_by_hh_composition:/J(1,6,pop)


/*Average age of family units/LATRs and Households*/
onep_age = (onep_all*Ages'):/(rowsum(onep_all))
twop_age = (twop_all*Ages'):/(rowsum(twop_all))
alon_age = (alon_all*Ages'):/(rowsum(alon_all))
mult_age = (mult_all*Ages'):/(rowsum(mult_all))
cple_age = (cple_all*Ages'):/(rowsum(cple_all))
multif_age = ((onep_age:*onep_number_in_m)+ (twop_age:*twop_number_in_m)):/multif
hh_age = (alon_age,onep_age,twop_age,multif_age,mult_age,cple_age)

onep_age_growth[2..rows(onep_age_growth)] = (onep_age[2..rows(onep_age)]-onep_age[1..(rows(onep_age)-1)]):/onep_age[Time_length-1,.]

twop_age_growth[2..rows(twop_age_growth)] = (twop_age[2..rows(twop_age)] - twop_age[1..(rows(twop_age)-1)]):/twop_age[Time_length-1,.]

alon_age_growth[2..rows(alon_age_growth)] = diff(alon_age):/alon_age[Time_length-1,.] 
mult_age_growth[2..rows(alon_age_growth)] = (mult_age[2..rows(mult_age)] - mult_age[1..(rows(mult_age)-1)]):/mult_age[Time_length-1,.] 
cple_age_growth[2..rows(alon_age_growth)] = (cple_age[2..rows(cple_age)] - cple_age[1..(rows(cple_age)-1)]):/cple_age[Time_length-1,.] 
multif_age_growth[2..rows(multif_age_growth)] = (multif_age[2..rows(multif_age)] - multif_age[1..(rows(multif_age)-1)]):/multif_age[Time_length-1,.] 

/*Family aggregates by 'adult' and 'child'*/
families_adults = (rowsum(alon_all[.,19..(rows(alon_all))]), rowsum(onep_all[.,19..(rows(alon_all))]), rowsum(twop_all[.,19..(rows(alon_all))]), rowsum(mult_all[.,19..(rows(alon_all))]), rowsum(cple_all[.,19..(rows(alon_all))]))
families_children = (rowsum(alon_all[.,1..18]), rowsum(onep_all[.,1..18]), rowsum(twop_all[.,1..18]), rowsum(mult_all[.,1..18]), rowsum(cple_all[.,1..18]))
pop_by_family_type = (rowsum(alon_all), rowsum(onep_all), rowsum(twop_all), rowsum(mult_all), rowsum(cple_all))
family_composition = (rowsum(alon_a),rowsum(onep_a),rowsum(onep_c), rowsum(onep_o),rowsum(twop_a),rowsum(twop_c), rowsum(twop_o), rowsum(cple_a), rowsum(cple_o),rowsum(mult_o), rowsum(nonprv))  


/* NATIONAL LABOUR FORCE FORECASTS*/

/*(a) Participation rates  tweaked to roughly match TSY LTFM. Based on*/
/*logistic growth curves and long run assumed maximums. This needs to be*/
/*changed to a Bayesian projection taking account of eg neighbourhood*/
/*effects. */


for (j=1; j<=lfpr_bands_n; j++) {
	for (i=HL+1; i<=TL; i++) {
		lfpr_fcast_m[i,j] = lfpr_fcast_m[i-1,j] + (lfpr_m_star[j]-lfpr_fcast_m[i-1,j])/((1:+	lfpr_S[j]:*exp(-lfpr_b[j]:*((Time_t[i]-lfpr_T[j])))):^(1/lfpr_v[j])) 
		lfpr_fcast_f[i,j] = lfpr_fcast_f[i-1,j] + (lfpr_f_star[j]-lfpr_fcast_f[i-1,j])/((1:+lfpr_S[j]:*exp(-lfpr_b[j]:*((Time_t[i]-lfpr_T[j])))):^(1/lfpr_v[j])) 

	}
}


/*(b) Labour force*/
/*male labour force by age bands*/
/*female labour force by age bands*/
/*total labour force by age bands*/
/*total labour force*/
/*all age lfpr*/
lf_m_bands = pop_m_workage_bands:*lfpr_fcast_m 
lf_f_bands = pop_f_workage_bands:*lfpr_fcast_f 
lf_tot_bands = lf_m_bands + lf_f_bands 
lf_tot = rowsum(lf_tot_bands) 
lfpr_tot = lf_tot:/pop_workage 
lf_delta = lf_tot[2..rows(lf_tot)]-lf_tot[1..(rows(lf_tot)-1)]
lf_growth[2..rows(lf_growth),.] = lf_delta:/lf_tot[1..(Time_length-1),.]

/*(c) employment - rate assumed constant for the time being (stochastic to*/
/*be added).*/
 *Note the <= returns 59 elements*/
for (i=History_length+1; i<=Time_length;i++){
	unemployment_fcast_rate[i,.] = unemployment_fcast_rate[i-1,.] + ((lr_unemployment_rate-unemployment_fcast_rate[i-1,.]):/lr_unemployment_adjustment_speed)
}
employment = lf_tot:*(1:-(unemployment_fcast_rate:*emp_cycle))
employment_delta = employment[2..rows(employment)]-employment[1..(rows(employment)-1)]
employment_growth[2..(rows(employment_growth)),.] = employment_delta:/employment[2..Time_length,.]

/* CALCULATE REGIONAL FORECAST AGGREGATES*/

/*NOR*/
nor_pop_fcast_tot= nor_pop_fcast_m + nor_pop_fcast_f
nor_pop = rowsum(nor_pop_fcast_tot)

/*Calculate working age population, working age 5 yr bands, and dependency ratios*/
nor_pop_m_workage = rowsum(nor_pop_fcast_m[.,16..cols(nor_pop_fcast_m)])
nor_pop_f_workage = rowsum(nor_pop_fcast_f[.,16..cols(nor_pop_fcast_f)])
nor_pop_workage = nor_pop_m_workage + nor_pop_f_workage
nor_pop_m_15to64 = rowsum(nor_pop_fcast_m[.,16..65])
nor_pop_f_15to64 = rowsum(nor_pop_fcast_f[.,16..65])
nor_pop_15to64 = nor_pop_f_15to64 + nor_pop_m_15to64
nor_pop_m_ova64 = rowsum(nor_pop_fcast_m[.,66..(cols(nor_pop_fcast_m))])
nor_pop_f_ova64 = rowsum(nor_pop_fcast_f[.,66..(cols(nor_pop_fcast_f))])
nor_pop_m_unda15 = rowsum(nor_pop_fcast_m[.,1..15])
nor_pop_f_unda15 = rowsum(nor_pop_fcast_f[.,1..15])
nor_pop_ova64 = nor_pop_m_ova64 + nor_pop_f_ova64
nor_pop_unda15 = nor_pop_m_unda15 + nor_pop_f_unda15
nor_pop_dependent = nor_pop_ova64 + nor_pop_unda15
nor_pop_dependent_ratio = nor_pop_dependent:/nor_pop_15to64
nor_pop_m_15to19 = rowsum(nor_pop_fcast_m[.,16..20])
nor_pop_m_20to24 = rowsum(nor_pop_fcast_m[.,21..25])
nor_pop_m_25to29 = rowsum(nor_pop_fcast_m[.,26..30])
nor_pop_m_30to34 = rowsum(nor_pop_fcast_m[.,31..35])
nor_pop_m_35to39 = rowsum(nor_pop_fcast_m[.,36..40])
nor_pop_m_40to44 = rowsum(nor_pop_fcast_m[.,41..45])
nor_pop_m_45to49 = rowsum(nor_pop_fcast_m[.,46..50])
nor_pop_m_50to54 = rowsum(nor_pop_fcast_m[.,51..55])
nor_pop_m_55to59 = rowsum(nor_pop_fcast_m[.,56..60])
nor_pop_m_60to64 = rowsum(nor_pop_fcast_m[.,61..65])
nor_pop_f_15to19 = rowsum(nor_pop_fcast_f[.,16..20])
nor_pop_f_20to24 = rowsum(nor_pop_fcast_f[.,21..25])
nor_pop_f_25to29 = rowsum(nor_pop_fcast_f[.,26..30])
nor_pop_f_30to34 = rowsum(nor_pop_fcast_f[.,31..35])
nor_pop_f_35to39 = rowsum(nor_pop_fcast_f[.,36..40])
nor_pop_f_40to44 = rowsum(nor_pop_fcast_f[.,41..45])
nor_pop_f_45to49 = rowsum(nor_pop_fcast_f[.,46..50])
nor_pop_f_50to54 = rowsum(nor_pop_fcast_f[.,51..55])
nor_pop_f_55to59 = rowsum(nor_pop_fcast_f[.,56..60])
nor_pop_f_60to64 = rowsum(nor_pop_fcast_f[.,61..65])
nor_pop_m_workage_bands = (nor_pop_m_15to19,nor_pop_m_20to24,nor_pop_m_25to29,nor_pop_m_30to34,nor_pop_m_35to39, nor_pop_m_40to44, nor_pop_m_45to49, nor_pop_m_50to54, nor_pop_m_55to59, nor_pop_m_60to64, nor_pop_m_ova64)
nor_pop_f_workage_bands = (nor_pop_f_15to19,nor_pop_f_20to24,nor_pop_f_25to29,nor_pop_f_30to34,nor_pop_f_35to39, nor_pop_f_40to44, nor_pop_f_45to49, nor_pop_f_50to54, nor_pop_f_55to59, nor_pop_f_60to64, nor_pop_f_ova64)
nor_pop_workage_bands = nor_pop_m_workage_bands + nor_pop_f_workage_bands
nor_age_bands = (nor_pop_unda15,nor_pop_workage_bands)

/*Calculate average age of the population*/
nor_pop_ave_age = (nor_pop_fcast_tot*Ages'):/nor_pop

/*AKL*/
akl_pop_fcast_tot= akl_pop_fcast_m + akl_pop_fcast_f
akl_pop = rowsum(akl_pop_fcast_tot)

/*Calculate working age population, working age 5 yr bands, and dependency ratios*/
akl_pop_m_workage = rowsum(akl_pop_fcast_m[.,16..cols(akl_pop_fcast_m)])
akl_pop_f_workage = rowsum(akl_pop_fcast_f[.,16..cols(akl_pop_fcast_f)])
akl_pop_workage = akl_pop_m_workage + akl_pop_f_workage
akl_pop_m_15to64 = rowsum(akl_pop_fcast_m[.,16..65])
akl_pop_f_15to64 = rowsum(akl_pop_fcast_f[.,16..65])
akl_pop_15to64 = akl_pop_f_15to64 + akl_pop_m_15to64
akl_pop_m_ova64 = rowsum(akl_pop_fcast_m[.,66..(cols(akl_pop_fcast_m))])
akl_pop_f_ova64 = rowsum(akl_pop_fcast_f[.,66..(cols(akl_pop_fcast_f))])
akl_pop_m_unda15 = rowsum(akl_pop_fcast_m[.,1..15])
akl_pop_f_unda15 = rowsum(akl_pop_fcast_f[.,1..15])
akl_pop_ova64 = akl_pop_m_ova64 + akl_pop_f_ova64
akl_pop_unda15 = akl_pop_m_unda15 + akl_pop_f_unda15
akl_pop_dependent = akl_pop_ova64 + akl_pop_unda15
akl_pop_dependent_ratio = akl_pop_dependent:/akl_pop_15to64
akl_pop_m_15to19 = rowsum(akl_pop_fcast_m[.,16..20])
akl_pop_m_20to24 = rowsum(akl_pop_fcast_m[.,21..25])
akl_pop_m_25to29 = rowsum(akl_pop_fcast_m[.,26..30])
akl_pop_m_30to34 = rowsum(akl_pop_fcast_m[.,31..35])
akl_pop_m_35to39 = rowsum(akl_pop_fcast_m[.,36..40])
akl_pop_m_40to44 = rowsum(akl_pop_fcast_m[.,41..45])
akl_pop_m_45to49 = rowsum(akl_pop_fcast_m[.,46..50])
akl_pop_m_50to54 = rowsum(akl_pop_fcast_m[.,51..55])
akl_pop_m_55to59 = rowsum(akl_pop_fcast_m[.,56..60])
akl_pop_m_60to64 = rowsum(akl_pop_fcast_m[.,61..65])
akl_pop_f_15to19 = rowsum(akl_pop_fcast_f[.,16..20])
akl_pop_f_20to24 = rowsum(akl_pop_fcast_f[.,21..25])
akl_pop_f_25to29 = rowsum(akl_pop_fcast_f[.,26..30])
akl_pop_f_30to34 = rowsum(akl_pop_fcast_f[.,31..35])
akl_pop_f_35to39 = rowsum(akl_pop_fcast_f[.,36..40])
akl_pop_f_40to44 = rowsum(akl_pop_fcast_f[.,41..45])
akl_pop_f_45to49 = rowsum(akl_pop_fcast_f[.,46..50])
akl_pop_f_50to54 = rowsum(akl_pop_fcast_f[.,51..55])
akl_pop_f_55to59 = rowsum(akl_pop_fcast_f[.,56..60])
akl_pop_f_60to64 = rowsum(akl_pop_fcast_f[.,61..65])
akl_pop_m_workage_bands = (akl_pop_m_15to19,akl_pop_m_20to24,akl_pop_m_25to29,akl_pop_m_30to34,akl_pop_m_35to39, akl_pop_m_40to44, akl_pop_m_45to49, akl_pop_m_50to54, akl_pop_m_55to59, akl_pop_m_60to64, akl_pop_m_ova64)
akl_pop_f_workage_bands = (akl_pop_f_15to19,akl_pop_f_20to24,akl_pop_f_25to29,akl_pop_f_30to34,akl_pop_f_35to39, akl_pop_f_40to44, akl_pop_f_45to49, akl_pop_f_50to54, akl_pop_f_55to59, akl_pop_f_60to64, akl_pop_f_ova64)
akl_pop_workage_bands = akl_pop_m_workage_bands + akl_pop_f_workage_bands
akl_age_bands = (akl_pop_unda15,akl_pop_workage_bands)

/*Calculate average age of the population*/
akl_pop_ave_age = (akl_pop_fcast_tot*Ages'):/akl_pop

/*WAI*/
wai_pop_fcast_tot= wai_pop_fcast_m + wai_pop_fcast_f
wai_pop = rowsum(wai_pop_fcast_tot)

/*Calculate working age population, working age 5 yr bands, and dependency ratios*/
wai_pop_m_workage = rowsum(wai_pop_fcast_m[.,16..cols(wai_pop_fcast_m)])
wai_pop_f_workage = rowsum(wai_pop_fcast_f[.,16..cols(wai_pop_fcast_f)])
wai_pop_workage = wai_pop_m_workage + wai_pop_f_workage
wai_pop_m_15to64 = rowsum(wai_pop_fcast_m[.,16..65])
wai_pop_f_15to64 = rowsum(wai_pop_fcast_f[.,16..65])
wai_pop_15to64 = wai_pop_f_15to64 + wai_pop_m_15to64
wai_pop_m_ova64 = rowsum(wai_pop_fcast_m[.,66..(cols(wai_pop_fcast_m))])
wai_pop_f_ova64 = rowsum(wai_pop_fcast_f[.,66..(cols(wai_pop_fcast_f))])
wai_pop_m_unda15 = rowsum(wai_pop_fcast_m[.,1..15])
wai_pop_f_unda15 = rowsum(wai_pop_fcast_f[.,1..15])
wai_pop_ova64 = wai_pop_m_ova64 + wai_pop_f_ova64
wai_pop_unda15 = wai_pop_m_unda15 + wai_pop_f_unda15
wai_pop_dependent = wai_pop_ova64 + wai_pop_unda15
wai_pop_dependent_ratio = wai_pop_dependent:/wai_pop_15to64
wai_pop_m_15to19 = rowsum(wai_pop_fcast_m[.,16..20])
wai_pop_m_20to24 = rowsum(wai_pop_fcast_m[.,21..25])
wai_pop_m_25to29 = rowsum(wai_pop_fcast_m[.,26..30])
wai_pop_m_30to34 = rowsum(wai_pop_fcast_m[.,31..35])
wai_pop_m_35to39 = rowsum(wai_pop_fcast_m[.,36..40])
wai_pop_m_40to44 = rowsum(wai_pop_fcast_m[.,41..45])
wai_pop_m_45to49 = rowsum(wai_pop_fcast_m[.,46..50])
wai_pop_m_50to54 = rowsum(wai_pop_fcast_m[.,51..55])
wai_pop_m_55to59 = rowsum(wai_pop_fcast_m[.,56..60])
wai_pop_m_60to64 = rowsum(wai_pop_fcast_m[.,61..65])
wai_pop_f_15to19 = rowsum(wai_pop_fcast_f[.,16..20])
wai_pop_f_20to24 = rowsum(wai_pop_fcast_f[.,21..25])
wai_pop_f_25to29 = rowsum(wai_pop_fcast_f[.,26..30])
wai_pop_f_30to34 = rowsum(wai_pop_fcast_f[.,31..35])
wai_pop_f_35to39 = rowsum(wai_pop_fcast_f[.,36..40])
wai_pop_f_40to44 = rowsum(wai_pop_fcast_f[.,41..45])
wai_pop_f_45to49 = rowsum(wai_pop_fcast_f[.,46..50])
wai_pop_f_50to54 = rowsum(wai_pop_fcast_f[.,51..55])
wai_pop_f_55to59 = rowsum(wai_pop_fcast_f[.,56..60])
wai_pop_f_60to64 = rowsum(wai_pop_fcast_f[.,61..65])
wai_pop_m_workage_bands = (wai_pop_m_15to19,wai_pop_m_20to24,wai_pop_m_25to29,wai_pop_m_30to34,wai_pop_m_35to39, wai_pop_m_40to44, wai_pop_m_45to49, wai_pop_m_50to54, wai_pop_m_55to59, wai_pop_m_60to64, wai_pop_m_ova64)
wai_pop_f_workage_bands = (wai_pop_f_15to19,wai_pop_f_20to24,wai_pop_f_25to29,wai_pop_f_30to34,wai_pop_f_35to39, wai_pop_f_40to44, wai_pop_f_45to49, wai_pop_f_50to54, wai_pop_f_55to59, wai_pop_f_60to64, wai_pop_f_ova64)
wai_pop_workage_bands = wai_pop_m_workage_bands + wai_pop_f_workage_bands
wai_age_bands = (wai_pop_unda15,wai_pop_workage_bands)

/*Calculate average age of the population*/
wai_pop_ave_age = (wai_pop_fcast_tot*Ages'):/wai_pop


/*BOP*/
bop_pop_fcast_tot= bop_pop_fcast_m + bop_pop_fcast_f
bop_pop = rowsum(bop_pop_fcast_tot)

/*Calculate working age population, working age 5 yr bands, and dependency ratios*/
bop_pop_m_workage = rowsum(bop_pop_fcast_m[.,16..cols(bop_pop_fcast_m)])
bop_pop_f_workage = rowsum(bop_pop_fcast_f[.,16..cols(bop_pop_fcast_f)])
bop_pop_workage = bop_pop_m_workage + bop_pop_f_workage
bop_pop_m_15to64 = rowsum(bop_pop_fcast_m[.,16..65])
bop_pop_f_15to64 = rowsum(bop_pop_fcast_f[.,16..65])
bop_pop_15to64 = bop_pop_f_15to64 + bop_pop_m_15to64
bop_pop_m_ova64 = rowsum(bop_pop_fcast_m[.,66..(cols(bop_pop_fcast_m))])
bop_pop_f_ova64 = rowsum(bop_pop_fcast_f[.,66..(cols(bop_pop_fcast_f))])
bop_pop_m_unda15 = rowsum(bop_pop_fcast_m[.,1..15])
bop_pop_f_unda15 = rowsum(bop_pop_fcast_f[.,1..15])
bop_pop_ova64 = bop_pop_m_ova64 + bop_pop_f_ova64
bop_pop_unda15 = bop_pop_m_unda15 + bop_pop_f_unda15
bop_pop_dependent = bop_pop_ova64 + bop_pop_unda15
bop_pop_dependent_ratio = bop_pop_dependent:/bop_pop_15to64
bop_pop_m_15to19 = rowsum(bop_pop_fcast_m[.,16..20])
bop_pop_m_20to24 = rowsum(bop_pop_fcast_m[.,21..25])
bop_pop_m_25to29 = rowsum(bop_pop_fcast_m[.,26..30])
bop_pop_m_30to34 = rowsum(bop_pop_fcast_m[.,31..35])
bop_pop_m_35to39 = rowsum(bop_pop_fcast_m[.,36..40])
bop_pop_m_40to44 = rowsum(bop_pop_fcast_m[.,41..45])
bop_pop_m_45to49 = rowsum(bop_pop_fcast_m[.,46..50])
bop_pop_m_50to54 = rowsum(bop_pop_fcast_m[.,51..55])
bop_pop_m_55to59 = rowsum(bop_pop_fcast_m[.,56..60])
bop_pop_m_60to64 = rowsum(bop_pop_fcast_m[.,61..65])
bop_pop_f_15to19 = rowsum(bop_pop_fcast_f[.,16..20])
bop_pop_f_20to24 = rowsum(bop_pop_fcast_f[.,21..25])
bop_pop_f_25to29 = rowsum(bop_pop_fcast_f[.,26..30])
bop_pop_f_30to34 = rowsum(bop_pop_fcast_f[.,31..35])
bop_pop_f_35to39 = rowsum(bop_pop_fcast_f[.,36..40])
bop_pop_f_40to44 = rowsum(bop_pop_fcast_f[.,41..45])
bop_pop_f_45to49 = rowsum(bop_pop_fcast_f[.,46..50])
bop_pop_f_50to54 = rowsum(bop_pop_fcast_f[.,51..55])
bop_pop_f_55to59 = rowsum(bop_pop_fcast_f[.,56..60])
bop_pop_f_60to64 = rowsum(bop_pop_fcast_f[.,61..65])
bop_pop_m_workage_bands = (bop_pop_m_15to19,bop_pop_m_20to24,bop_pop_m_25to29,bop_pop_m_30to34,bop_pop_m_35to39, bop_pop_m_40to44, bop_pop_m_45to49, bop_pop_m_50to54, bop_pop_m_55to59, bop_pop_m_60to64, bop_pop_m_ova64)
bop_pop_f_workage_bands = (bop_pop_f_15to19,bop_pop_f_20to24,bop_pop_f_25to29,bop_pop_f_30to34,bop_pop_f_35to39, bop_pop_f_40to44, bop_pop_f_45to49, bop_pop_f_50to54, bop_pop_f_55to59, bop_pop_f_60to64, bop_pop_f_ova64)
bop_pop_workage_bands = bop_pop_m_workage_bands + bop_pop_f_workage_bands
bop_age_bands = (bop_pop_unda15,bop_pop_workage_bands)

/*Calculate average age of the population*/
bop_pop_ave_age = (bop_pop_fcast_tot*Ages'):/bop_pop

/*TAR*/
tar_pop_fcast_tot= tar_pop_fcast_m + tar_pop_fcast_f
tar_pop = rowsum(tar_pop_fcast_tot)

/*Calculate working age population, working age 5 yr bands, and dependency ratios*/
tar_pop_m_workage = rowsum(tar_pop_fcast_m[.,16..cols(tar_pop_fcast_m)])
tar_pop_f_workage = rowsum(tar_pop_fcast_f[.,16..cols(tar_pop_fcast_m)])
tar_pop_workage = tar_pop_m_workage + tar_pop_f_workage
tar_pop_m_15to64 = rowsum(tar_pop_fcast_m[.,16..65])
tar_pop_f_15to64 = rowsum(tar_pop_fcast_f[.,16..65])
tar_pop_15to64 = tar_pop_f_15to64 + tar_pop_m_15to64
tar_pop_m_ova64 = rowsum(tar_pop_fcast_m[.,66..(cols(tar_pop_fcast_m))])
tar_pop_f_ova64 = rowsum(tar_pop_fcast_f[.,66..(cols(tar_pop_fcast_f))])
tar_pop_m_unda15 = rowsum(tar_pop_fcast_m[.,1..15])
tar_pop_f_unda15 = rowsum(tar_pop_fcast_f[.,1..15])
tar_pop_ova64 = tar_pop_m_ova64 + tar_pop_f_ova64
tar_pop_unda15 = tar_pop_m_unda15 + tar_pop_f_unda15
tar_pop_dependent = tar_pop_ova64 + tar_pop_unda15
tar_pop_dependent_ratio = tar_pop_dependent:/tar_pop_15to64
tar_pop_m_15to19 = rowsum(tar_pop_fcast_m[.,16..20])
tar_pop_m_20to24 = rowsum(tar_pop_fcast_m[.,21..25])
tar_pop_m_25to29 = rowsum(tar_pop_fcast_m[.,26..30])
tar_pop_m_30to34 = rowsum(tar_pop_fcast_m[.,31..35])
tar_pop_m_35to39 = rowsum(tar_pop_fcast_m[.,36..40])
tar_pop_m_40to44 = rowsum(tar_pop_fcast_m[.,41..45])
tar_pop_m_45to49 = rowsum(tar_pop_fcast_m[.,46..50])
tar_pop_m_50to54 = rowsum(tar_pop_fcast_m[.,51..55])
tar_pop_m_55to59 = rowsum(tar_pop_fcast_m[.,56..60])
tar_pop_m_60to64 = rowsum(tar_pop_fcast_m[.,61..65])
tar_pop_f_15to19 = rowsum(tar_pop_fcast_f[.,16..20])
tar_pop_f_20to24 = rowsum(tar_pop_fcast_f[.,21..25])
tar_pop_f_25to29 = rowsum(tar_pop_fcast_f[.,26..30])
tar_pop_f_30to34 = rowsum(tar_pop_fcast_f[.,31..35])
tar_pop_f_35to39 = rowsum(tar_pop_fcast_f[.,36..40])
tar_pop_f_40to44 = rowsum(tar_pop_fcast_f[.,41..45])
tar_pop_f_45to49 = rowsum(tar_pop_fcast_f[.,46..50])
tar_pop_f_50to54 = rowsum(tar_pop_fcast_f[.,51..55])
tar_pop_f_55to59 = rowsum(tar_pop_fcast_f[.,56..60])
tar_pop_f_60to64 = rowsum(tar_pop_fcast_f[.,61..65])
tar_pop_m_workage_bands = (tar_pop_m_15to19,tar_pop_m_20to24,tar_pop_m_25to29,tar_pop_m_30to34,tar_pop_m_35to39, tar_pop_m_40to44, tar_pop_m_45to49, tar_pop_m_50to54, tar_pop_m_55to59, tar_pop_m_60to64, tar_pop_m_ova64)
tar_pop_f_workage_bands = (tar_pop_f_15to19,tar_pop_f_20to24,tar_pop_f_25to29,tar_pop_f_30to34,tar_pop_f_35to39, tar_pop_f_40to44, tar_pop_f_45to49, tar_pop_f_50to54, tar_pop_f_55to59, tar_pop_f_60to64, tar_pop_f_ova64)
tar_pop_workage_bands = tar_pop_m_workage_bands + tar_pop_f_workage_bands
tar_age_bands = (tar_pop_unda15,tar_pop_workage_bands)

/*Calculate average age of the population*/
tar_pop_ave_age = (tar_pop_fcast_tot*Ages'):/tar_pop

/*MAN*/
man_pop_fcast_tot= man_pop_fcast_m + man_pop_fcast_f
man_pop = rowsum(man_pop_fcast_tot)

/*Calculate working age population, working age 5 yr bands, and dependency ratios*/
man_pop_m_workage = rowsum(man_pop_fcast_m[.,16..cols(man_pop_fcast_m)])
man_pop_f_workage = rowsum(man_pop_fcast_f[.,16..cols(man_pop_fcast_f)])
man_pop_workage = man_pop_m_workage + man_pop_f_workage
man_pop_m_15to64 = rowsum(man_pop_fcast_m[.,16..65])
man_pop_f_15to64 = rowsum(man_pop_fcast_f[.,16..65])
man_pop_15to64 = man_pop_f_15to64 + man_pop_m_15to64
man_pop_m_ova64 = rowsum(man_pop_fcast_m[.,66..(cols(man_pop_fcast_m))])
man_pop_f_ova64 = rowsum(man_pop_fcast_f[.,66..(cols(man_pop_fcast_f))])
man_pop_m_unda15 = rowsum(man_pop_fcast_m[.,1..15])
man_pop_f_unda15 = rowsum(man_pop_fcast_f[.,1..15])
man_pop_ova64 = man_pop_m_ova64 + man_pop_f_ova64
man_pop_unda15 = man_pop_m_unda15 + man_pop_f_unda15
man_pop_dependent = man_pop_ova64 + man_pop_unda15
man_pop_dependent_ratio = man_pop_dependent:/man_pop_15to64
man_pop_m_15to19 = rowsum(man_pop_fcast_m[.,16..20])
man_pop_m_20to24 = rowsum(man_pop_fcast_m[.,21..25])
man_pop_m_25to29 = rowsum(man_pop_fcast_m[.,26..30])
man_pop_m_30to34 = rowsum(man_pop_fcast_m[.,31..35])
man_pop_m_35to39 = rowsum(man_pop_fcast_m[.,36..40])
man_pop_m_40to44 = rowsum(man_pop_fcast_m[.,41..45])
man_pop_m_45to49 = rowsum(man_pop_fcast_m[.,46..50])
man_pop_m_50to54 = rowsum(man_pop_fcast_m[.,51..55])
man_pop_m_55to59 = rowsum(man_pop_fcast_m[.,56..60])
man_pop_m_60to64 = rowsum(man_pop_fcast_m[.,61..65])
man_pop_f_15to19 = rowsum(man_pop_fcast_f[.,16..20])
man_pop_f_20to24 = rowsum(man_pop_fcast_f[.,21..25])
man_pop_f_25to29 = rowsum(man_pop_fcast_f[.,26..30])
man_pop_f_30to34 = rowsum(man_pop_fcast_f[.,31..35])
man_pop_f_35to39 = rowsum(man_pop_fcast_f[.,36..40])
man_pop_f_40to44 = rowsum(man_pop_fcast_f[.,41..45])
man_pop_f_45to49 = rowsum(man_pop_fcast_f[.,46..50])
man_pop_f_50to54 = rowsum(man_pop_fcast_f[.,51..55])
man_pop_f_55to59 = rowsum(man_pop_fcast_f[.,56..60])
man_pop_f_60to64 = rowsum(man_pop_fcast_f[.,61..65])
man_pop_m_workage_bands = (man_pop_m_15to19,man_pop_m_20to24,man_pop_m_25to29,man_pop_m_30to34,man_pop_m_35to39, man_pop_m_40to44, man_pop_m_45to49, man_pop_m_50to54, man_pop_m_55to59, man_pop_m_60to64, man_pop_m_ova64)
man_pop_f_workage_bands = (man_pop_f_15to19,man_pop_f_20to24,man_pop_f_25to29,man_pop_f_30to34,man_pop_f_35to39, man_pop_f_40to44, man_pop_f_45to49, man_pop_f_50to54, man_pop_f_55to59, man_pop_f_60to64, man_pop_f_ova64)
man_pop_workage_bands = man_pop_m_workage_bands + man_pop_f_workage_bands
man_age_bands = (man_pop_unda15,man_pop_workage_bands)

/*Calculate average age of the population*/
man_pop_ave_age = (man_pop_fcast_tot*Ages'):/man_pop

/*WEL*/
wel_pop_fcast_tot= wel_pop_fcast_m + wel_pop_fcast_f
wel_pop = rowsum(wel_pop_fcast_tot)

/*Calculate working age population, working age 5 yr bands, and dependency ratios*/
wel_pop_m_workage = rowsum(wel_pop_fcast_m[.,16..cols(wel_pop_fcast_m)])
wel_pop_f_workage = rowsum(wel_pop_fcast_f[.,16..cols(wel_pop_fcast_f)])
wel_pop_workage = wel_pop_m_workage + wel_pop_f_workage
wel_pop_m_15to64 = rowsum(wel_pop_fcast_m[.,16..65])
wel_pop_f_15to64 = rowsum(wel_pop_fcast_f[.,16..65])
wel_pop_15to64 = wel_pop_f_15to64 + wel_pop_m_15to64
wel_pop_m_ova64 = rowsum(wel_pop_fcast_m[.,66..(cols(wel_pop_fcast_m))])
wel_pop_f_ova64 = rowsum(wel_pop_fcast_f[.,66..(cols(wel_pop_fcast_f))])
wel_pop_m_unda15 = rowsum(wel_pop_fcast_m[.,1..15])
wel_pop_f_unda15 = rowsum(wel_pop_fcast_f[.,1..15])
wel_pop_ova64 = wel_pop_m_ova64 + wel_pop_f_ova64
wel_pop_unda15 = wel_pop_m_unda15 + wel_pop_f_unda15
wel_pop_dependent = wel_pop_ova64 + wel_pop_unda15
wel_pop_dependent_ratio = wel_pop_dependent:/wel_pop_15to64
wel_pop_m_15to19 = rowsum(wel_pop_fcast_m[.,16..20])
wel_pop_m_20to24 = rowsum(wel_pop_fcast_m[.,21..25])
wel_pop_m_25to29 = rowsum(wel_pop_fcast_m[.,26..30])
wel_pop_m_30to34 = rowsum(wel_pop_fcast_m[.,31..35])
wel_pop_m_35to39 = rowsum(wel_pop_fcast_m[.,36..40])
wel_pop_m_40to44 = rowsum(wel_pop_fcast_m[.,41..45])
wel_pop_m_45to49 = rowsum(wel_pop_fcast_m[.,46..50])
wel_pop_m_50to54 = rowsum(wel_pop_fcast_m[.,51..55])
wel_pop_m_55to59 = rowsum(wel_pop_fcast_m[.,56..60])
wel_pop_m_60to64 = rowsum(wel_pop_fcast_m[.,61..65])
wel_pop_f_15to19 = rowsum(wel_pop_fcast_f[.,16..20])
wel_pop_f_20to24 = rowsum(wel_pop_fcast_f[.,21..25])
wel_pop_f_25to29 = rowsum(wel_pop_fcast_f[.,26..30])
wel_pop_f_30to34 = rowsum(wel_pop_fcast_f[.,31..35])
wel_pop_f_35to39 = rowsum(wel_pop_fcast_f[.,36..40])
wel_pop_f_40to44 = rowsum(wel_pop_fcast_f[.,41..45])
wel_pop_f_45to49 = rowsum(wel_pop_fcast_f[.,46..50])
wel_pop_f_50to54 = rowsum(wel_pop_fcast_f[.,51..55])
wel_pop_f_55to59 = rowsum(wel_pop_fcast_f[.,56..60])
wel_pop_f_60to64 = rowsum(wel_pop_fcast_f[.,61..65])
wel_pop_m_workage_bands = (wel_pop_m_15to19,wel_pop_m_20to24,wel_pop_m_25to29,wel_pop_m_30to34,wel_pop_m_35to39, wel_pop_m_40to44, wel_pop_m_45to49, wel_pop_m_50to54, wel_pop_m_55to59, wel_pop_m_60to64, wel_pop_m_ova64)
wel_pop_f_workage_bands = (wel_pop_f_15to19,wel_pop_f_20to24,wel_pop_f_25to29,wel_pop_f_30to34,wel_pop_f_35to39, wel_pop_f_40to44, wel_pop_f_45to49, wel_pop_f_50to54, wel_pop_f_55to59, wel_pop_f_60to64, wel_pop_f_ova64)
wel_pop_workage_bands = wel_pop_m_workage_bands + wel_pop_f_workage_bands
wel_age_bands = (wel_pop_unda15,wel_pop_workage_bands)

/*Calculate average age of the population*/
wel_pop_ave_age = (wel_pop_fcast_tot*Ages'):/wel_pop


/*CAN*/
can_pop_fcast_tot= can_pop_fcast_m + can_pop_fcast_f
can_pop = rowsum(can_pop_fcast_tot)

/*Calculate working age population, working age 5 yr bands, and dependency ratios*/
can_pop_m_workage = rowsum(can_pop_fcast_m[.,16..cols(can_pop_fcast_m)])
can_pop_f_workage = rowsum(can_pop_fcast_f[.,16..cols(can_pop_fcast_f)])
can_pop_workage = can_pop_m_workage + can_pop_f_workage
can_pop_m_15to64 = rowsum(can_pop_fcast_m[.,16..65])
can_pop_f_15to64 = rowsum(can_pop_fcast_f[.,16..65])
can_pop_15to64 = can_pop_f_15to64 + can_pop_m_15to64
can_pop_m_ova64 = rowsum(can_pop_fcast_m[.,66..(cols(can_pop_fcast_m))])
can_pop_f_ova64 = rowsum(can_pop_fcast_f[.,66..(cols(can_pop_fcast_f))])
can_pop_m_unda15 = rowsum(can_pop_fcast_m[.,1..15])
can_pop_f_unda15 = rowsum(can_pop_fcast_f[.,1..15])
can_pop_ova64 = can_pop_m_ova64 + can_pop_f_ova64
can_pop_unda15 = can_pop_m_unda15 + can_pop_f_unda15
can_pop_dependent = can_pop_ova64 + can_pop_unda15
can_pop_dependent_ratio = can_pop_dependent:/can_pop_15to64
can_pop_m_15to19 = rowsum(can_pop_fcast_m[.,16..20])
can_pop_m_20to24 = rowsum(can_pop_fcast_m[.,21..25])
can_pop_m_25to29 = rowsum(can_pop_fcast_m[.,26..30])
can_pop_m_30to34 = rowsum(can_pop_fcast_m[.,31..35])
can_pop_m_35to39 = rowsum(can_pop_fcast_m[.,36..40])
can_pop_m_40to44 = rowsum(can_pop_fcast_m[.,41..45])
can_pop_m_45to49 = rowsum(can_pop_fcast_m[.,46..50])
can_pop_m_50to54 = rowsum(can_pop_fcast_m[.,51..55])
can_pop_m_55to59 = rowsum(can_pop_fcast_m[.,56..60])
can_pop_m_60to64 = rowsum(can_pop_fcast_m[.,61..65])
can_pop_f_15to19 = rowsum(can_pop_fcast_f[.,16..20])
can_pop_f_20to24 = rowsum(can_pop_fcast_f[.,21..25])
can_pop_f_25to29 = rowsum(can_pop_fcast_f[.,26..30])
can_pop_f_30to34 = rowsum(can_pop_fcast_f[.,31..35])
can_pop_f_35to39 = rowsum(can_pop_fcast_f[.,36..40])
can_pop_f_40to44 = rowsum(can_pop_fcast_f[.,41..45])
can_pop_f_45to49 = rowsum(can_pop_fcast_f[.,46..50])
can_pop_f_50to54 = rowsum(can_pop_fcast_f[.,51..55])
can_pop_f_55to59 = rowsum(can_pop_fcast_f[.,56..60])
can_pop_f_60to64 = rowsum(can_pop_fcast_f[.,61..65])
can_pop_m_workage_bands = (can_pop_m_15to19,can_pop_m_20to24,can_pop_m_25to29,can_pop_m_30to34,can_pop_m_35to39, can_pop_m_40to44, can_pop_m_45to49, can_pop_m_50to54, can_pop_m_55to59, can_pop_m_60to64, can_pop_m_ova64)
can_pop_f_workage_bands = (can_pop_f_15to19,can_pop_f_20to24,can_pop_f_25to29,can_pop_f_30to34,can_pop_f_35to39, can_pop_f_40to44, can_pop_f_45to49, can_pop_f_50to54, can_pop_f_55to59, can_pop_f_60to64, can_pop_f_ova64)
can_pop_workage_bands = can_pop_m_workage_bands + can_pop_f_workage_bands
can_age_bands = (can_pop_unda15,can_pop_workage_bands)

/*Calculate average age of the population*/
can_pop_ave_age = (can_pop_fcast_tot*Ages'):/can_pop


/*OTG*/
otg_pop_fcast_tot= otg_pop_fcast_m + otg_pop_fcast_f
otg_pop = rowsum(otg_pop_fcast_tot)

/*Calculate working age population, working age 5 yr bands, and dependency ratios*/
otg_pop_m_workage = rowsum(otg_pop_fcast_m[.,16..cols(otg_pop_fcast_m)])
otg_pop_f_workage = rowsum(otg_pop_fcast_f[.,16..cols(otg_pop_fcast_f)])
otg_pop_workage = otg_pop_m_workage + otg_pop_f_workage
otg_pop_m_15to64 = rowsum(otg_pop_fcast_m[.,16..65])
otg_pop_f_15to64 = rowsum(otg_pop_fcast_f[.,16..65])
otg_pop_15to64 = otg_pop_f_15to64 + otg_pop_m_15to64
otg_pop_m_ova64 = rowsum(otg_pop_fcast_m[.,66..(cols(otg_pop_fcast_m))])
otg_pop_f_ova64 = rowsum(otg_pop_fcast_f[.,66..(cols(otg_pop_fcast_f))])
otg_pop_m_unda15 = rowsum(otg_pop_fcast_m[.,1..15])
otg_pop_f_unda15 = rowsum(otg_pop_fcast_f[.,1..15])
otg_pop_ova64 = otg_pop_m_ova64 + otg_pop_f_ova64
otg_pop_unda15 = otg_pop_m_unda15 + otg_pop_f_unda15
otg_pop_dependent = otg_pop_ova64 + otg_pop_unda15
otg_pop_dependent_ratio = otg_pop_dependent:/otg_pop_15to64
otg_pop_m_15to19 = rowsum(otg_pop_fcast_m[.,16..20])
otg_pop_m_20to24 = rowsum(otg_pop_fcast_m[.,21..25])
otg_pop_m_25to29 = rowsum(otg_pop_fcast_m[.,26..30])
otg_pop_m_30to34 = rowsum(otg_pop_fcast_m[.,31..35])
otg_pop_m_35to39 = rowsum(otg_pop_fcast_m[.,36..40])
otg_pop_m_40to44 = rowsum(otg_pop_fcast_m[.,41..45])
otg_pop_m_45to49 = rowsum(otg_pop_fcast_m[.,46..50])
otg_pop_m_50to54 = rowsum(otg_pop_fcast_m[.,51..55])
otg_pop_m_55to59 = rowsum(otg_pop_fcast_m[.,56..60])
otg_pop_m_60to64 = rowsum(otg_pop_fcast_m[.,61..65])
otg_pop_f_15to19 = rowsum(otg_pop_fcast_f[.,16..20])
otg_pop_f_20to24 = rowsum(otg_pop_fcast_f[.,21..25])
otg_pop_f_25to29 = rowsum(otg_pop_fcast_f[.,26..30])
otg_pop_f_30to34 = rowsum(otg_pop_fcast_f[.,31..35])
otg_pop_f_35to39 = rowsum(otg_pop_fcast_f[.,36..40])
otg_pop_f_40to44 = rowsum(otg_pop_fcast_f[.,41..45])
otg_pop_f_45to49 = rowsum(otg_pop_fcast_f[.,46..50])
otg_pop_f_50to54 = rowsum(otg_pop_fcast_f[.,51..55])
otg_pop_f_55to59 = rowsum(otg_pop_fcast_f[.,56..60])
otg_pop_f_60to64 = rowsum(otg_pop_fcast_f[.,61..65])
otg_pop_m_workage_bands = (otg_pop_m_15to19,otg_pop_m_20to24,otg_pop_m_25to29,otg_pop_m_30to34,otg_pop_m_35to39, otg_pop_m_40to44, otg_pop_m_45to49, otg_pop_m_50to54, otg_pop_m_55to59, otg_pop_m_60to64, otg_pop_m_ova64)
otg_pop_f_workage_bands = (otg_pop_f_15to19,otg_pop_f_20to24,otg_pop_f_25to29,otg_pop_f_30to34,otg_pop_f_35to39, otg_pop_f_40to44, otg_pop_f_45to49, otg_pop_f_50to54, otg_pop_f_55to59, otg_pop_f_60to64, otg_pop_f_ova64)
otg_pop_workage_bands = otg_pop_m_workage_bands + otg_pop_f_workage_bands
otg_age_bands = (otg_pop_unda15,otg_pop_workage_bands)

/*Calculate average age of the population*/
otg_pop_ave_age = (otg_pop_fcast_tot*Ages'):/otg_pop

/*STH*/
sth_pop_fcast_tot= sth_pop_fcast_m + sth_pop_fcast_f
sth_pop = rowsum(sth_pop_fcast_tot)

/*Calculate working age population, working age 5 yr bands, and dependency ratios*/
sth_pop_m_workage = rowsum(sth_pop_fcast_m[.,16..cols(sth_pop_fcast_m)])
sth_pop_f_workage = rowsum(sth_pop_fcast_f[.,16..cols(sth_pop_fcast_f)])
sth_pop_workage = sth_pop_m_workage + sth_pop_f_workage
sth_pop_m_15to64 = rowsum(sth_pop_fcast_m[.,16..65])
sth_pop_f_15to64 = rowsum(sth_pop_fcast_f[.,16..65])
sth_pop_15to64 = sth_pop_f_15to64 + sth_pop_m_15to64
sth_pop_m_ova64 = rowsum(sth_pop_fcast_m[.,66..(cols(sth_pop_fcast_m))])
sth_pop_f_ova64 = rowsum(sth_pop_fcast_f[.,66..(cols(sth_pop_fcast_f))])
sth_pop_m_unda15 = rowsum(sth_pop_fcast_m[.,1..15])
sth_pop_f_unda15 = rowsum(sth_pop_fcast_f[.,1..15])
sth_pop_ova64 = sth_pop_m_ova64 + sth_pop_f_ova64
sth_pop_unda15 = sth_pop_m_unda15 + sth_pop_f_unda15
sth_pop_dependent = sth_pop_ova64 + sth_pop_unda15
sth_pop_dependent_ratio = sth_pop_dependent:/sth_pop_15to64
sth_pop_m_15to19 = rowsum(sth_pop_fcast_m[.,16..20])
sth_pop_m_20to24 = rowsum(sth_pop_fcast_m[.,21..25])
sth_pop_m_25to29 = rowsum(sth_pop_fcast_m[.,26..30])
sth_pop_m_30to34 = rowsum(sth_pop_fcast_m[.,31..35])
sth_pop_m_35to39 = rowsum(sth_pop_fcast_m[.,36..40])
sth_pop_m_40to44 = rowsum(sth_pop_fcast_m[.,41..45])
sth_pop_m_45to49 = rowsum(sth_pop_fcast_m[.,46..50])
sth_pop_m_50to54 = rowsum(sth_pop_fcast_m[.,51..55])
sth_pop_m_55to59 = rowsum(sth_pop_fcast_m[.,56..60])
sth_pop_m_60to64 = rowsum(sth_pop_fcast_m[.,61..65])
sth_pop_f_15to19 = rowsum(sth_pop_fcast_f[.,16..20])
sth_pop_f_20to24 = rowsum(sth_pop_fcast_f[.,21..25])
sth_pop_f_25to29 = rowsum(sth_pop_fcast_f[.,26..30])
sth_pop_f_30to34 = rowsum(sth_pop_fcast_f[.,31..35])
sth_pop_f_35to39 = rowsum(sth_pop_fcast_f[.,36..40])
sth_pop_f_40to44 = rowsum(sth_pop_fcast_f[.,41..45])
sth_pop_f_45to49 = rowsum(sth_pop_fcast_f[.,46..50])
sth_pop_f_50to54 = rowsum(sth_pop_fcast_f[.,51..55])
sth_pop_f_55to59 = rowsum(sth_pop_fcast_f[.,56..60])
sth_pop_f_60to64 = rowsum(sth_pop_fcast_f[.,61..65])
sth_pop_m_workage_bands = (sth_pop_m_15to19,sth_pop_m_20to24,sth_pop_m_25to29,sth_pop_m_30to34,sth_pop_m_35to39, sth_pop_m_40to44, sth_pop_m_45to49, sth_pop_m_50to54, sth_pop_m_55to59, sth_pop_m_60to64, sth_pop_m_ova64)
sth_pop_f_workage_bands = (sth_pop_f_15to19,sth_pop_f_20to24,sth_pop_f_25to29,sth_pop_f_30to34,sth_pop_f_35to39, sth_pop_f_40to44, sth_pop_f_45to49, sth_pop_f_50to54, sth_pop_f_55to59, sth_pop_f_60to64, sth_pop_f_ova64)
sth_pop_workage_bands = sth_pop_m_workage_bands + sth_pop_f_workage_bands
sth_age_bands = (sth_pop_unda15,sth_pop_workage_bands)

/*Calculate average age of the population*/
sth_pop_ave_age = (sth_pop_fcast_tot*Ages'):/sth_pop

/*GIS*/
gis_pop_fcast_tot= gis_pop_fcast_m + gis_pop_fcast_f
gis_pop = rowsum(gis_pop_fcast_tot)

/*Calculate working age population, working age 5 yr bands, and dependency ratios*/
gis_pop_m_workage = rowsum(gis_pop_fcast_m[.,16..cols(gis_pop_fcast_m)])
gis_pop_f_workage = rowsum(gis_pop_fcast_f[.,16..cols(gis_pop_fcast_f)])
gis_pop_workage = gis_pop_m_workage + gis_pop_f_workage
gis_pop_m_15to64 = rowsum(gis_pop_fcast_m[.,16..65])
gis_pop_f_15to64 = rowsum(gis_pop_fcast_f[.,16..65])
gis_pop_15to64 = gis_pop_f_15to64 + gis_pop_m_15to64
gis_pop_m_ova64 = rowsum(gis_pop_fcast_m[.,66..(cols(gis_pop_fcast_m))])
gis_pop_f_ova64 = rowsum(gis_pop_fcast_f[.,66..(cols(gis_pop_fcast_f))])
gis_pop_m_unda15 = rowsum(gis_pop_fcast_m[.,1..15])
gis_pop_f_unda15 = rowsum(gis_pop_fcast_f[.,1..15])
gis_pop_ova64 = gis_pop_m_ova64 + gis_pop_f_ova64
gis_pop_unda15 = gis_pop_m_unda15 + gis_pop_f_unda15
gis_pop_dependent = gis_pop_ova64 + gis_pop_unda15
gis_pop_dependent_ratio = gis_pop_dependent:/gis_pop_15to64
gis_pop_m_15to19 = rowsum(gis_pop_fcast_m[.,16..20])
gis_pop_m_20to24 = rowsum(gis_pop_fcast_m[.,21..25])
gis_pop_m_25to29 = rowsum(gis_pop_fcast_m[.,26..30])
gis_pop_m_30to34 = rowsum(gis_pop_fcast_m[.,31..35])
gis_pop_m_35to39 = rowsum(gis_pop_fcast_m[.,36..40])
gis_pop_m_40to44 = rowsum(gis_pop_fcast_m[.,41..45])
gis_pop_m_45to49 = rowsum(gis_pop_fcast_m[.,46..50])
gis_pop_m_50to54 = rowsum(gis_pop_fcast_m[.,51..55])
gis_pop_m_55to59 = rowsum(gis_pop_fcast_m[.,56..60])
gis_pop_m_60to64 = rowsum(gis_pop_fcast_m[.,61..65])
gis_pop_f_15to19 = rowsum(gis_pop_fcast_f[.,16..20])
gis_pop_f_20to24 = rowsum(gis_pop_fcast_f[.,21..25])
gis_pop_f_25to29 = rowsum(gis_pop_fcast_f[.,26..30])
gis_pop_f_30to34 = rowsum(gis_pop_fcast_f[.,31..35])
gis_pop_f_35to39 = rowsum(gis_pop_fcast_f[.,36..40])
gis_pop_f_40to44 = rowsum(gis_pop_fcast_f[.,41..45])
gis_pop_f_45to49 = rowsum(gis_pop_fcast_f[.,46..50])
gis_pop_f_50to54 = rowsum(gis_pop_fcast_f[.,51..55])
gis_pop_f_55to59 = rowsum(gis_pop_fcast_f[.,56..60])
gis_pop_f_60to64 = rowsum(gis_pop_fcast_f[.,61..65])
gis_pop_m_workage_bands = (gis_pop_m_15to19,gis_pop_m_20to24,gis_pop_m_25to29,gis_pop_m_30to34,gis_pop_m_35to39, gis_pop_m_40to44, gis_pop_m_45to49, gis_pop_m_50to54, gis_pop_m_55to59, gis_pop_m_60to64, gis_pop_m_ova64)
gis_pop_f_workage_bands = (gis_pop_f_15to19,gis_pop_f_20to24,gis_pop_f_25to29,gis_pop_f_30to34,gis_pop_f_35to39, gis_pop_f_40to44, gis_pop_f_45to49, gis_pop_f_50to54, gis_pop_f_55to59, gis_pop_f_60to64, gis_pop_f_ova64)
gis_pop_workage_bands = gis_pop_m_workage_bands + gis_pop_f_workage_bands
gis_age_bands = (gis_pop_unda15,gis_pop_workage_bands)

/*Calculate average age of the population*/
gis_pop_ave_age = (gis_pop_fcast_tot*Ages'):/gis_pop

/*USI*/
usi_pop_fcast_tot= usi_pop_fcast_m + usi_pop_fcast_f
usi_pop = rowsum(usi_pop_fcast_tot)

/*Calculate working age population, working age 5 yr bands, and dependency ratios*/
usi_pop_m_workage = rowsum(usi_pop_fcast_m[.,16..cols(usi_pop_fcast_m)])
usi_pop_f_workage = rowsum(usi_pop_fcast_f[.,16..cols(usi_pop_fcast_f)])
usi_pop_workage = usi_pop_m_workage + usi_pop_f_workage
usi_pop_m_15to64 = rowsum(usi_pop_fcast_m[.,16..65])
usi_pop_f_15to64 = rowsum(usi_pop_fcast_f[.,16..65])
usi_pop_15to64 = usi_pop_f_15to64 + usi_pop_m_15to64
usi_pop_m_ova64 = rowsum(usi_pop_fcast_m[.,66..(cols(usi_pop_fcast_m))])
usi_pop_f_ova64 = rowsum(usi_pop_fcast_f[.,66..(cols(usi_pop_fcast_f))])
usi_pop_m_unda15 = rowsum(usi_pop_fcast_m[.,1..15])
usi_pop_f_unda15 = rowsum(usi_pop_fcast_f[.,1..15])
usi_pop_ova64 = usi_pop_m_ova64 + usi_pop_f_ova64
usi_pop_unda15 = usi_pop_m_unda15 + usi_pop_f_unda15
usi_pop_dependent = usi_pop_ova64 + usi_pop_unda15
usi_pop_dependent_ratio = usi_pop_dependent:/usi_pop_15to64
usi_pop_m_15to19 = rowsum(usi_pop_fcast_m[.,16..20])
usi_pop_m_20to24 = rowsum(usi_pop_fcast_m[.,21..25])
usi_pop_m_25to29 = rowsum(usi_pop_fcast_m[.,26..30])
usi_pop_m_30to34 = rowsum(usi_pop_fcast_m[.,31..35])
usi_pop_m_35to39 = rowsum(usi_pop_fcast_m[.,36..40])
usi_pop_m_40to44 = rowsum(usi_pop_fcast_m[.,41..45])
usi_pop_m_45to49 = rowsum(usi_pop_fcast_m[.,46..50])
usi_pop_m_50to54 = rowsum(usi_pop_fcast_m[.,51..55])
usi_pop_m_55to59 = rowsum(usi_pop_fcast_m[.,56..60])
usi_pop_m_60to64 = rowsum(usi_pop_fcast_m[.,61..65])
usi_pop_f_15to19 = rowsum(usi_pop_fcast_f[.,16..20])
usi_pop_f_20to24 = rowsum(usi_pop_fcast_f[.,21..25])
usi_pop_f_25to29 = rowsum(usi_pop_fcast_f[.,26..30])
usi_pop_f_30to34 = rowsum(usi_pop_fcast_f[.,31..35])
usi_pop_f_35to39 = rowsum(usi_pop_fcast_f[.,36..40])
usi_pop_f_40to44 = rowsum(usi_pop_fcast_f[.,41..45])
usi_pop_f_45to49 = rowsum(usi_pop_fcast_f[.,46..50])
usi_pop_f_50to54 = rowsum(usi_pop_fcast_f[.,51..55])
usi_pop_f_55to59 = rowsum(usi_pop_fcast_f[.,56..60])
usi_pop_f_60to64 = rowsum(usi_pop_fcast_f[.,61..65])
usi_pop_m_workage_bands = (usi_pop_m_15to19,usi_pop_m_20to24,usi_pop_m_25to29,usi_pop_m_30to34,usi_pop_m_35to39, usi_pop_m_40to44, usi_pop_m_45to49, usi_pop_m_50to54, usi_pop_m_55to59, usi_pop_m_60to64, usi_pop_m_ova64)
usi_pop_f_workage_bands = (usi_pop_f_15to19,usi_pop_f_20to24,usi_pop_f_25to29,usi_pop_f_30to34,usi_pop_f_35to39, usi_pop_f_40to44, usi_pop_f_45to49, usi_pop_f_50to54, usi_pop_f_55to59, usi_pop_f_60to64, usi_pop_f_ova64)
usi_pop_workage_bands = usi_pop_m_workage_bands + usi_pop_f_workage_bands
usi_age_bands = (usi_pop_unda15,usi_pop_workage_bands)



/*Calculate average age of the population*/
usi_pop_ave_age = (usi_pop_fcast_tot*Ages'):/usi_pop

/*CALCULATE HH forecasts*/

/*NOR*/

/*(a) Project population by living arrangement*/

/*(i) first for each category of person and gender*/
nor_f_onep_c = nor_pop_fcast_f:*LATR_f[1..TL,.]
nor_f_twop_c = nor_pop_fcast_f:*LATR_f[1+TL*1..TL+TL*1,.]
nor_f_alon_a = nor_pop_fcast_f:*LATR_f[1+TL*2..TL+TL*2,.]
nor_f_mult_o = nor_pop_fcast_f:*LATR_f[1+TL*3..TL+TL*3,.]
nor_f_cple_o = nor_pop_fcast_f:*LATR_f[1+TL*4..TL+TL*4,.]
nor_f_onep_o = nor_pop_fcast_f:*LATR_f[1+TL*5..TL+TL*5,.]
nor_f_twop_o = nor_pop_fcast_f:*LATR_f[1+TL*6..TL+TL*6,.]
nor_f_onep_a = nor_pop_fcast_f:*LATR_f[1+TL*7..TL+TL*7,.]
nor_f_cple_a = nor_pop_fcast_f:*LATR_f[1+TL*8..TL+TL*8,.]
nor_f_twop_a = nor_pop_fcast_f:*LATR_f[1+TL*9..TL+TL*9,.]
nor_f_nonprv = nor_pop_fcast_f:*LATR_f[1+TL*10..TL+TL*10,.]
nor_m_onep_c = nor_pop_fcast_m:*LATR_m[1..TL,.]
nor_m_twop_c = nor_pop_fcast_m:*LATR_m[1+TL*1..TL+TL*1,.]
nor_m_alon_a = nor_pop_fcast_m:*LATR_m[1+TL*2..TL+TL*2,.]
nor_m_mult_o = nor_pop_fcast_m:*LATR_m[1+TL*3..TL+TL*3,.]
nor_m_cple_o = nor_pop_fcast_m:*LATR_m[1+TL*4..TL+TL*4,.]
nor_m_onep_o = nor_pop_fcast_m:*LATR_m[1+TL*5..TL+TL*5,.]
nor_m_twop_o = nor_pop_fcast_m:*LATR_m[1+TL*6..TL+TL*6,.]
nor_m_onep_a = nor_pop_fcast_m:*LATR_m[1+TL*7..TL+TL*7,.]
nor_m_cple_a = nor_pop_fcast_m:*LATR_m[1+TL*8..TL+TL*8,.]
nor_m_twop_a = nor_pop_fcast_m:*LATR_m[1+TL*9..TL+TL*9,.]
nor_m_nonprv = nor_pop_fcast_m:*LATR_m[1+TL*10..TL+TL*10,.]

/*(ii) then aggregating over gender*/
nor_onep_c = nor_f_onep_c + nor_m_onep_c
nor_twop_c = nor_f_twop_c + nor_m_twop_c
nor_alon_a = nor_f_alon_a + nor_m_alon_a
nor_mult_o = nor_f_mult_o + nor_m_mult_o
nor_cple_o = nor_f_cple_o + nor_m_cple_o
nor_onep_o = nor_f_onep_o + nor_m_onep_o 
nor_twop_o = nor_f_twop_o + nor_m_twop_o  
nor_onep_a = nor_f_onep_a + nor_m_onep_a 
nor_cple_a = nor_f_cple_a + nor_m_cple_a
nor_twop_a = nor_f_twop_a + nor_m_twop_a 
nor_nonprv = nor_f_nonprv + nor_m_nonprv 

/* (iii) then summing over family types to give number of people, by age, in each living arrangement/family type*/

nor_onep_all = (nor_onep_c + nor_onep_a + nor_onep_o):*J(1,Ages_n,1:-multif_onep)
nor_twop_all = (nor_twop_c + nor_twop_a + nor_twop_o):*J(1,Ages_n,1:-multif_twop)
nor_alon_all = nor_alon_a
nor_mult_all = nor_mult_o
nor_cple_all = nor_cple_a + nor_cple_o
nor_multif_all = (nor_onep_c + nor_onep_a + nor_onep_o)+(nor_twop_c + nor_twop_a + nor_twop_o)-(nor_onep_all + nor_twop_all)
nor_families = rowsum(nor_onep_a)+ rowsum(nor_cple_a)*0.5 + rowsum(nor_twop_a)*0.5
/*Household numbers*/
/*oneparent households*/
/*two parent households*/
/* multi family households*/
/*couple (no kids) households*/
/* sole person households*/
/*multi person households*/
/*non private dwelling i.e. not counted as a hh*/

nor_onep = (1:-multif_onep):*(rowsum(nor_onep_a))
nor_twop = (1:-multif_twop):*(rowsum(nor_twop_a)*0.5)
nor_onep_number_in_m = (multif_onep):*(rowsum(nor_onep_a))
nor_twop_number_in_m = ((multif_twop):*(rowsum(nor_twop_a)*0.5))
nor_multif = nor_onep_number_in_m + nor_twop_number_in_m 
nor_cple = rowsum(nor_cple_a)*0.5
nor_alon = rowsum(nor_alon_a) 
nor_multi = rowsum(nor_mult_o):/people_per_multi 
nor_nonhh = rowsum(nor_nonprv)


/*Household aggregates*/
/* this is the way statsnz calculates number of HH*/
/* this is the number of households consistent with the model*/

nor_households_aggr = nor_families:/fam_per_hh + rowsum(nor_mult_o):/people_per_multi + rowsum(nor_alon_a) 
nor_households = (nor_onep + nor_twop + nor_alon + nor_multif + nor_cple + nor_multi)
nor_people_per_hh = (nor_pop-nor_nonhh):/nor_households
nor_people_per_onep = (rowsum(nor_onep_c) + rowsum(nor_onep_a) + rowsum(nor_onep_o)):/rowsum(nor_onep_a)
nor_people_per_twop = (rowsum(nor_twop_c) + rowsum(nor_twop_a) + rowsum(nor_twop_o)):/(rowsum(nor_twop_a)*0.5)
nor_people_per_cple = (rowsum(nor_cple_a) + rowsum(nor_cple_o)):/nor_cple
nor_people_per_multif =  (((multif_onep):*(rowsum(nor_onep_a)+rowsum(nor_onep_c)+rowsum(nor_onep_o))) + ((multif_twop):*(rowsum(nor_twop_a)+rowsum(nor_twop_c)+rowsum(nor_twop_o)))):/nor_multif


nor_people_per_alon = J(TL,1,1)
nor_hh_size = (nor_people_per_alon,nor_people_per_onep,nor_people_per_twop,nor_people_per_multif,people_per_multi,nor_people_per_cple)
nor_hh_composition =(nor_alon,nor_onep,nor_twop,nor_multif,nor_multi,nor_cple)
nor_pop_by_hh_composition = nor_hh_composition:*nor_hh_size
nor_pop_by_hh_composition_shares = nor_pop_by_hh_composition:/J(1,6,nor_pop)

/*Average age of family units/LATRs and Households*/
/*assume no distinction in average age for thoe joining mutlifamily households*/
nor_onep_age = (nor_onep_all*Ages'):/(rowsum(nor_onep_all))
nor_twop_age = (nor_twop_all*Ages'):/(rowsum(nor_twop_all))
nor_alon_age = (nor_alon_all*Ages'):/(rowsum(nor_alon_all))
nor_mult_age = (nor_mult_all*Ages'):/(rowsum(nor_mult_all))
nor_cple_age = (nor_cple_all*Ages'):/(rowsum(nor_cple_all))
nor_multif_age = ((nor_onep_age:*nor_onep_number_in_m)+ (nor_twop_age:*nor_twop_number_in_m)):/nor_multif 
nor_hh_age = (nor_alon_age,nor_onep_age,nor_twop_age,nor_multif_age,nor_mult_age,nor_cple_age)

nor_onep_age_growth[2..rows(nor_onep_age_growth)] = diff(nor_onep_age):/nor_onep_age[Time_length-1,.]
nor_twop_age_growth[2..rows(nor_twop_age_growth)] = diff(nor_onep_age):/nor_onep_age[Time_length-1,.]
nor_alon_age_growth[2..rows(nor_alon_age_growth)] = diff(nor_alon_age):/nor_alon_age[Time_length-1,.] 
nor_mult_age_growth[2..rows(nor_mult_age_growth)] = diff(nor_mult_age):/nor_mult_age[Time_length-1,.] 
nor_cple_age_growth[2..rows(nor_cple_age_growth)] = diff(nor_cple_age):/nor_cple_age[Time_length-1,.] 
nor_multif_age_growth[2..rows(nor_multif_age_growth)] = diff(nor_multif_age):/nor_multif_age[Time_length-1,.]  

/*AKL*/

/*(a) Project population by living arrangement*/

/*(i) first for each category of person and gender*/
akl_f_onep_c = akl_pop_fcast_f:*LATR_f[1..TL,.]
akl_f_twop_c = akl_pop_fcast_f:*LATR_f[1+TL*1..TL+TL*1,.]
akl_f_alon_a = akl_pop_fcast_f:*LATR_f[1+TL*2..TL+TL*2,.]
akl_f_mult_o = akl_pop_fcast_f:*LATR_f[1+TL*3..TL+TL*3,.]
akl_f_cple_o = akl_pop_fcast_f:*LATR_f[1+TL*4..TL+TL*4,.]
akl_f_onep_o = akl_pop_fcast_f:*LATR_f[1+TL*5..TL+TL*5,.]
akl_f_twop_o = akl_pop_fcast_f:*LATR_f[1+TL*6..TL+TL*6,.]
akl_f_onep_a = akl_pop_fcast_f:*LATR_f[1+TL*7..TL+TL*7,.]
akl_f_cple_a = akl_pop_fcast_f:*LATR_f[1+TL*8..TL+TL*8,.]
akl_f_twop_a = akl_pop_fcast_f:*LATR_f[1+TL*9..TL+TL*9,.]
akl_f_nonprv = akl_pop_fcast_f:*LATR_f[1+TL*10..TL+TL*10,.]
akl_m_onep_c = akl_pop_fcast_m:*LATR_m[1..TL,.]
akl_m_twop_c = akl_pop_fcast_m:*LATR_m[1+TL*1..TL+TL*1,.]
akl_m_alon_a = akl_pop_fcast_m:*LATR_m[1+TL*2..TL+TL*2,.]
akl_m_mult_o = akl_pop_fcast_m:*LATR_m[1+TL*3..TL+TL*3,.]
akl_m_cple_o = akl_pop_fcast_m:*LATR_m[1+TL*4..TL+TL*4,.]
akl_m_onep_o = akl_pop_fcast_m:*LATR_m[1+TL*5..TL+TL*5,.]
akl_m_twop_o = akl_pop_fcast_m:*LATR_m[1+TL*6..TL+TL*6,.]
akl_m_onep_a = akl_pop_fcast_m:*LATR_m[1+TL*7..TL+TL*7,.]
akl_m_cple_a = akl_pop_fcast_m:*LATR_m[1+TL*8..TL+TL*8,.]
akl_m_twop_a = akl_pop_fcast_m:*LATR_m[1+TL*9..TL+TL*9,.]
akl_m_nonprv = akl_pop_fcast_m:*LATR_m[1+TL*10..TL+TL*10,.]

/*(ii) then aggregating over gender*/
akl_onep_c = akl_f_onep_c + akl_m_onep_c
akl_twop_c = akl_f_twop_c + akl_m_twop_c
akl_alon_a = akl_f_alon_a + akl_m_alon_a
akl_mult_o = akl_f_mult_o + akl_m_mult_o
akl_cple_o = akl_f_cple_o + akl_m_cple_o
akl_onep_o = akl_f_onep_o + akl_m_onep_o 
akl_twop_o = akl_f_twop_o + akl_m_twop_o  
akl_onep_a = akl_f_onep_a + akl_m_onep_a 
akl_cple_a = akl_f_cple_a + akl_m_cple_a
akl_twop_a = akl_f_twop_a + akl_m_twop_a 
akl_nonprv = akl_f_nonprv + akl_m_nonprv 

/* (iii) then summing over family types to give number of people, by age, in each living arrangement/family type*/

akl_onep_all = (akl_onep_c + akl_onep_a + akl_onep_o):*J(1,Ages_n,1:-multif_onep)
akl_twop_all = (akl_twop_c + akl_twop_a + akl_twop_o):*J(1,Ages_n,1:-multif_twop)
akl_alon_all = akl_alon_a
akl_mult_all = akl_mult_o
akl_cple_all = akl_cple_a + akl_cple_o
akl_multif_all = (akl_onep_c + akl_onep_a + akl_onep_o)+(akl_twop_c + akl_twop_a + akl_twop_o)-(akl_onep_all + akl_twop_all)
akl_families = rowsum(akl_onep_a)+ rowsum(akl_cple_a)*0.5 + rowsum(akl_twop_a)*0.5
/*Household numbers*/
/*oneparent households*/
/*two parent households*/
/* multi family households*/
/*couple (no kids) households*/
/* sole person households*/
/*multi person households*/
/*non private dwelling i.e. not counted as a hh*/

akl_onep = (1:-multif_onep):*(rowsum(akl_onep_a))
akl_twop = (1:-multif_twop):*(rowsum(akl_twop_a)*0.5)
akl_onep_number_in_m = (multif_onep):*(rowsum(akl_onep_a))
akl_twop_number_in_m = ((multif_twop):*(rowsum(akl_twop_a)*0.5))
akl_multif = akl_onep_number_in_m + akl_twop_number_in_m 
akl_cple = rowsum(akl_cple_a)*0.5
akl_alon = rowsum(akl_alon_a) 
akl_multi = rowsum(akl_mult_o):/people_per_multi 
akl_nonhh = rowsum(akl_nonprv)


/*Household aggregates*/
/* this is the way statsnz calculates number of HH*/
/* this is the number of households consistent with the model*/

akl_households_aggr = akl_families:/fam_per_hh + rowsum(akl_mult_o):/people_per_multi + rowsum(akl_alon_a) 
akl_households = (akl_onep + akl_twop + akl_alon + akl_multif + akl_cple + akl_multi)
akl_people_per_hh = (akl_pop-akl_nonhh):/akl_households
akl_people_per_onep = (rowsum(akl_onep_c) + rowsum(akl_onep_a) + rowsum(akl_onep_o)):/rowsum(akl_onep_a)
akl_people_per_twop = (rowsum(akl_twop_c) + rowsum(akl_twop_a) + rowsum(akl_twop_o)):/(rowsum(akl_twop_a)*0.5)
akl_people_per_cple = (rowsum(akl_cple_a) + rowsum(akl_cple_o)):/akl_cple
akl_people_per_multif =  (((multif_onep):*(rowsum(akl_onep_a)+rowsum(akl_onep_c)+rowsum(akl_onep_o))) + ((multif_twop):*(rowsum(akl_twop_a)+rowsum(akl_twop_c)+rowsum(akl_twop_o)))):/akl_multif


akl_people_per_alon = J(TL,1,1)
akl_hh_size = (akl_people_per_alon,akl_people_per_onep,akl_people_per_twop,akl_people_per_multif,people_per_multi,akl_people_per_cple)
akl_hh_composition =(akl_alon,akl_onep,akl_twop,akl_multif,akl_multi,akl_cple)
akl_pop_by_hh_composition = akl_hh_composition:*akl_hh_size
akl_pop_by_hh_composition_shares = akl_pop_by_hh_composition:/J(1,6,akl_pop)

/*Average age of family units/LATRs and Households*/
/*assume no distinction in average age for thoe joining mutlifamily households*/
akl_onep_age = (akl_onep_all*Ages'):/(rowsum(akl_onep_all))
akl_twop_age = (akl_twop_all*Ages'):/(rowsum(akl_twop_all))
akl_alon_age = (akl_alon_all*Ages'):/(rowsum(akl_alon_all))
akl_mult_age = (akl_mult_all*Ages'):/(rowsum(akl_mult_all))
akl_cple_age = (akl_cple_all*Ages'):/(rowsum(akl_cple_all))
akl_multif_age = ((akl_onep_age:*akl_onep_number_in_m)+ (akl_twop_age:*akl_twop_number_in_m)):/akl_multif 
akl_hh_age = (akl_alon_age,akl_onep_age,akl_twop_age,akl_multif_age,akl_mult_age,akl_cple_age)

akl_onep_age_growth[2..rows(akl_onep_age_growth)] = diff(akl_onep_age):/akl_onep_age[Time_length-1,.] 
akl_twop_age_growth[2..rows(akl_twop_age_growth)] = diff(akl_onep_age):/akl_onep_age[Time_length-1,.] 
akl_alon_age_growth[2..rows(akl_alon_age_growth)] = diff(akl_alon_age):/akl_alon_age[Time_length-1,.] 
akl_mult_age_growth[2..rows(akl_mult_age_growth)] = diff(akl_mult_age):/akl_mult_age[Time_length-1,.] 
akl_cple_age_growth[2..rows(akl_cple_age_growth)] = diff(akl_cple_age):/akl_cple_age[Time_length-1,.] 
akl_multif_age_growth[2..rows(akl_multif_age_growth)] = diff(akl_multif_age):/akl_multif_age[Time_length-1,.]  

/*WAI*/

/*(a) Project population by living arrangement*/

/*(i) first for each category of person and gender*/
wai_f_onep_c = wai_pop_fcast_f:*LATR_f[1..TL,.]
wai_f_twop_c = wai_pop_fcast_f:*LATR_f[1+TL*1..TL+TL*1,.]
wai_f_alon_a = wai_pop_fcast_f:*LATR_f[1+TL*2..TL+TL*2,.]
wai_f_mult_o = wai_pop_fcast_f:*LATR_f[1+TL*3..TL+TL*3,.]
wai_f_cple_o = wai_pop_fcast_f:*LATR_f[1+TL*4..TL+TL*4,.]
wai_f_onep_o = wai_pop_fcast_f:*LATR_f[1+TL*5..TL+TL*5,.]
wai_f_twop_o = wai_pop_fcast_f:*LATR_f[1+TL*6..TL+TL*6,.]
wai_f_onep_a = wai_pop_fcast_f:*LATR_f[1+TL*7..TL+TL*7,.]
wai_f_cple_a = wai_pop_fcast_f:*LATR_f[1+TL*8..TL+TL*8,.]
wai_f_twop_a = wai_pop_fcast_f:*LATR_f[1+TL*9..TL+TL*9,.]
wai_f_nonprv = wai_pop_fcast_f:*LATR_f[1+TL*10..TL+TL*10,.]
wai_m_onep_c = wai_pop_fcast_m:*LATR_m[1..TL,.]
wai_m_twop_c = wai_pop_fcast_m:*LATR_m[1+TL*1..TL+TL*1,.]
wai_m_alon_a = wai_pop_fcast_m:*LATR_m[1+TL*2..TL+TL*2,.]
wai_m_mult_o = wai_pop_fcast_m:*LATR_m[1+TL*3..TL+TL*3,.]
wai_m_cple_o = wai_pop_fcast_m:*LATR_m[1+TL*4..TL+TL*4,.]
wai_m_onep_o = wai_pop_fcast_m:*LATR_m[1+TL*5..TL+TL*5,.]
wai_m_twop_o = wai_pop_fcast_m:*LATR_m[1+TL*6..TL+TL*6,.]
wai_m_onep_a = wai_pop_fcast_m:*LATR_m[1+TL*7..TL+TL*7,.]
wai_m_cple_a = wai_pop_fcast_m:*LATR_m[1+TL*8..TL+TL*8,.]
wai_m_twop_a = wai_pop_fcast_m:*LATR_m[1+TL*9..TL+TL*9,.]
wai_m_nonprv = wai_pop_fcast_m:*LATR_m[1+TL*10..TL+TL*10,.]

/*(ii) then aggregating over gender*/
wai_onep_c = wai_f_onep_c + wai_m_onep_c
wai_twop_c = wai_f_twop_c + wai_m_twop_c
wai_alon_a = wai_f_alon_a + wai_m_alon_a
wai_mult_o = wai_f_mult_o + wai_m_mult_o
wai_cple_o = wai_f_cple_o + wai_m_cple_o
wai_onep_o = wai_f_onep_o + wai_m_onep_o 
wai_twop_o = wai_f_twop_o + wai_m_twop_o  
wai_onep_a = wai_f_onep_a + wai_m_onep_a 
wai_cple_a = wai_f_cple_a + wai_m_cple_a
wai_twop_a = wai_f_twop_a + wai_m_twop_a 
wai_nonprv = wai_f_nonprv + wai_m_nonprv 

/* (iii) then summing over family types to give number of people, by age, in each living arrangement/family type*/

wai_onep_all = (wai_onep_c + wai_onep_a + wai_onep_o):*J(1,Ages_n,1:-multif_onep)
wai_twop_all = (wai_twop_c + wai_twop_a + wai_twop_o):*J(1,Ages_n,1:-multif_twop)
wai_alon_all = wai_alon_a
wai_mult_all = wai_mult_o
wai_cple_all = wai_cple_a + wai_cple_o
wai_multif_all = (wai_onep_c + wai_onep_a + wai_onep_o)+(wai_twop_c + wai_twop_a + wai_twop_o)-(wai_onep_all + wai_twop_all)
wai_families = rowsum(wai_onep_a)+ rowsum(wai_cple_a)*0.5 + rowsum(wai_twop_a)*0.5
/*Household numbers*/
/*oneparent households*/
/*two parent households*/
/* multi family households*/
/*couple (no kids) households*/
/* sole person households*/
/*multi person households*/
/*non private dwelling i.e. not counted as a hh*/

wai_onep = (1:-multif_onep):*(rowsum(wai_onep_a))
wai_twop = (1:-multif_twop):*(rowsum(wai_twop_a)*0.5)
wai_onep_number_in_m = (multif_onep):*(rowsum(wai_onep_a))
wai_twop_number_in_m = ((multif_twop):*(rowsum(wai_twop_a)*0.5))
wai_multif = wai_onep_number_in_m + wai_twop_number_in_m
wai_cple = rowsum(wai_cple_a)*0.5
wai_alon = rowsum(wai_alon_a) 
wai_multi = rowsum(wai_mult_o):/people_per_multi 
wai_nonhh = rowsum(wai_nonprv)


/*Household aggregates*/
/* this is the way statsnz calculates number of HH*/
/* this is the number of households consistent with the model*/

wai_households_aggr = wai_families:/fam_per_hh + rowsum(wai_mult_o):/people_per_multi + rowsum(wai_alon_a) 
wai_households = (wai_onep + wai_twop + wai_alon + wai_multif + wai_cple + wai_multi)
wai_people_per_hh = (wai_pop-wai_nonhh):/wai_households
wai_people_per_onep = (rowsum(wai_onep_c) + rowsum(wai_onep_a) + rowsum(wai_onep_o)):/rowsum(wai_onep_a)
wai_people_per_twop = (rowsum(wai_twop_c) + rowsum(wai_twop_a) + rowsum(wai_twop_o)):/(rowsum(wai_twop_a)*0.5)
wai_people_per_cple = (rowsum(wai_cple_a) + rowsum(wai_cple_o)):/wai_cple
wai_people_per_multif =  (((multif_onep):*(rowsum(wai_onep_a)+rowsum(wai_onep_c)+rowsum(wai_onep_o))) + ((multif_twop):*(rowsum(wai_twop_a)+rowsum(wai_twop_c)+rowsum(wai_twop_o)))):/wai_multif


wai_people_per_alon = J(TL,1,1)
wai_hh_size = (wai_people_per_alon,wai_people_per_onep,wai_people_per_twop,wai_people_per_multif,people_per_multi,wai_people_per_cple)
wai_hh_composition =(wai_alon,wai_onep,wai_twop,wai_multif,wai_multi,wai_cple)
wai_pop_by_hh_composition = wai_hh_composition:*wai_hh_size
wai_pop_by_hh_composition_shares = wai_pop_by_hh_composition:/J(1,6,wai_pop)

/*Average age of family units/LATRs and Households*/
/*assume no distinction in average age for thoe joining mutlifamily households*/
wai_onep_age = (wai_onep_all*Ages'):/(rowsum(wai_onep_all))
wai_twop_age = (wai_twop_all*Ages'):/(rowsum(wai_twop_all))
wai_alon_age = (wai_alon_all*Ages'):/(rowsum(wai_alon_all))
wai_mult_age = (wai_mult_all*Ages'):/(rowsum(wai_mult_all))
wai_cple_age = (wai_cple_all*Ages'):/(rowsum(wai_cple_all))
wai_multif_age = ((wai_onep_age:*wai_onep_number_in_m)+ (wai_twop_age:*wai_twop_number_in_m)):/wai_multif 
wai_hh_age = (wai_alon_age,wai_onep_age,wai_twop_age,wai_multif_age,wai_mult_age,wai_cple_age)

wai_onep_age_growth[2..rows(wai_onep_age_growth)] = diff(wai_onep_age):/wai_onep_age[Time_length-1,.] 
wai_twop_age_growth[2..rows(wai_twop_age_growth)] = diff(wai_onep_age):/wai_onep_age[Time_length-1,.] 
wai_alon_age_growth[2..rows(wai_alon_age_growth)] = diff(wai_alon_age):/wai_alon_age[Time_length-1,.] 
wai_mult_age_growth[2..rows(wai_mult_age_growth)] = diff(wai_mult_age):/wai_mult_age[Time_length-1,.] 
wai_cple_age_growth[2..rows(wai_cple_age_growth)] = diff(wai_cple_age):/wai_cple_age[Time_length-1,.] 
wai_multif_age_growth[2..rows(wai_multif_age_growth)] = diff(wai_multif_age):/wai_multif_age[Time_length-1,.]  

/*BOP*/

/*(a) Project population by living arrangement*/

/*(i) first for each category of person and gender*/
bop_f_onep_c = bop_pop_fcast_f:*LATR_f[1..TL,.]
bop_f_twop_c = bop_pop_fcast_f:*LATR_f[1+TL*1..TL+TL*1,.]
bop_f_alon_a = bop_pop_fcast_f:*LATR_f[1+TL*2..TL+TL*2,.]
bop_f_mult_o = bop_pop_fcast_f:*LATR_f[1+TL*3..TL+TL*3,.]
bop_f_cple_o = bop_pop_fcast_f:*LATR_f[1+TL*4..TL+TL*4,.]
bop_f_onep_o = bop_pop_fcast_f:*LATR_f[1+TL*5..TL+TL*5,.]
bop_f_twop_o = bop_pop_fcast_f:*LATR_f[1+TL*6..TL+TL*6,.]
bop_f_onep_a = bop_pop_fcast_f:*LATR_f[1+TL*7..TL+TL*7,.]
bop_f_cple_a = bop_pop_fcast_f:*LATR_f[1+TL*8..TL+TL*8,.]
bop_f_twop_a = bop_pop_fcast_f:*LATR_f[1+TL*9..TL+TL*9,.]
bop_f_nonprv = bop_pop_fcast_f:*LATR_f[1+TL*10..TL+TL*10,.]
bop_m_onep_c = bop_pop_fcast_m:*LATR_m[1..TL,.]
bop_m_twop_c = bop_pop_fcast_m:*LATR_m[1+TL*1..TL+TL*1,.]
bop_m_alon_a = bop_pop_fcast_m:*LATR_m[1+TL*2..TL+TL*2,.]
bop_m_mult_o = bop_pop_fcast_m:*LATR_m[1+TL*3..TL+TL*3,.]
bop_m_cple_o = bop_pop_fcast_m:*LATR_m[1+TL*4..TL+TL*4,.]
bop_m_onep_o = bop_pop_fcast_m:*LATR_m[1+TL*5..TL+TL*5,.]
bop_m_twop_o = bop_pop_fcast_m:*LATR_m[1+TL*6..TL+TL*6,.]
bop_m_onep_a = bop_pop_fcast_m:*LATR_m[1+TL*7..TL+TL*7,.]
bop_m_cple_a = bop_pop_fcast_m:*LATR_m[1+TL*8..TL+TL*8,.]
bop_m_twop_a = bop_pop_fcast_m:*LATR_m[1+TL*9..TL+TL*9,.]
bop_m_nonprv = bop_pop_fcast_m:*LATR_m[1+TL*10..TL+TL*10,.]

/*(ii) then aggregating over gender*/
bop_onep_c = bop_f_onep_c + bop_m_onep_c
bop_twop_c = bop_f_twop_c + bop_m_twop_c
bop_alon_a = bop_f_alon_a + bop_m_alon_a
bop_mult_o = bop_f_mult_o + bop_m_mult_o
bop_cple_o = bop_f_cple_o + bop_m_cple_o
bop_onep_o = bop_f_onep_o + bop_m_onep_o 
bop_twop_o = bop_f_twop_o + bop_m_twop_o  
bop_onep_a = bop_f_onep_a + bop_m_onep_a 
bop_cple_a = bop_f_cple_a + bop_m_cple_a
bop_twop_a = bop_f_twop_a + bop_m_twop_a 
bop_nonprv = bop_f_nonprv + bop_m_nonprv 

/* (iii) then summing over family types to give number of people, by age, in each living arrangement/family type*/

bop_onep_all = (bop_onep_c + bop_onep_a + bop_onep_o):*J(1,Ages_n,1:-multif_onep)
bop_twop_all = (bop_twop_c + bop_twop_a + bop_twop_o):*J(1,Ages_n,1:-multif_twop)
bop_alon_all = bop_alon_a
bop_mult_all = bop_mult_o
bop_cple_all = bop_cple_a + bop_cple_o
bop_multif_all = (bop_onep_c + bop_onep_a + bop_onep_o)+(bop_twop_c + bop_twop_a + bop_twop_o)-(bop_onep_all + bop_twop_all)
bop_families = rowsum(bop_onep_a)+ rowsum(bop_cple_a)*0.5 + rowsum(bop_twop_a)*0.5
/*Household numbers*/
/*oneparent households*/
/*two parent households*/
/* multi family households*/
/*couple (no kids) households*/
/* sole person households*/
/*multi person households*/
/*non private dwelling i.e. not counted as a hh*/

bop_onep = (1:-multif_onep):*(rowsum(bop_onep_a))
bop_twop = (1:-multif_twop):*(rowsum(bop_twop_a)*0.5)
bop_onep_number_in_m = (multif_onep):*(rowsum(bop_onep_a))
bop_twop_number_in_m = ((multif_twop):*(rowsum(bop_twop_a)*0.5))
bop_multif = bop_onep_number_in_m + bop_twop_number_in_m
bop_cple = rowsum(bop_cple_a)*0.5
bop_alon = rowsum(bop_alon_a) 
bop_multi = rowsum(bop_mult_o):/people_per_multi 
bop_nonhh = rowsum(bop_nonprv)


/*Household aggregates*/
/* this is the way statsnz calculates number of HH*/
/* this is the number of households consistent with the model*/

bop_households_aggr = bop_families:/fam_per_hh + rowsum(bop_mult_o):/people_per_multi + rowsum(bop_alon_a) 
bop_households = (bop_onep + bop_twop + bop_alon + bop_multif + bop_cple + bop_multi)
bop_people_per_hh = (bop_pop-bop_nonhh):/bop_households
bop_people_per_onep = (rowsum(bop_onep_c) + rowsum(bop_onep_a) + rowsum(bop_onep_o)):/rowsum(bop_onep_a)
bop_people_per_twop = (rowsum(bop_twop_c) + rowsum(bop_twop_a) + rowsum(bop_twop_o)):/(rowsum(bop_twop_a)*0.5)
bop_people_per_cple = (rowsum(bop_cple_a) + rowsum(bop_cple_o)):/bop_cple
bop_people_per_multif =  (((multif_onep):*(rowsum(bop_onep_a)+rowsum(bop_onep_c)+rowsum(bop_onep_o))) + ((multif_twop):*(rowsum(bop_twop_a)+rowsum(bop_twop_c)+rowsum(bop_twop_o)))):/bop_multif


bop_people_per_alon = J(TL,1,1)
bop_hh_size = (bop_people_per_alon,bop_people_per_onep,bop_people_per_twop,bop_people_per_multif,people_per_multi,bop_people_per_cple)
bop_hh_composition =(bop_alon,bop_onep,bop_twop,bop_multif,bop_multi,bop_cple)
bop_pop_by_hh_composition = bop_hh_composition:*bop_hh_size
bop_pop_by_hh_composition_shares = bop_pop_by_hh_composition:/J(1,6,bop_pop)

/*Average age of family units/LATRs and Households*/
/*assume no distinction in average age for thoe joining mutlifamily households*/
bop_onep_age = (bop_onep_all*Ages'):/(rowsum(bop_onep_all))
bop_twop_age = (bop_twop_all*Ages'):/(rowsum(bop_twop_all))
bop_alon_age = (bop_alon_all*Ages'):/(rowsum(bop_alon_all))
bop_mult_age = (bop_mult_all*Ages'):/(rowsum(bop_mult_all))
bop_cple_age = (bop_cple_all*Ages'):/(rowsum(bop_cple_all))
bop_multif_age = ((bop_onep_age:*bop_onep_number_in_m)+ (bop_twop_age:*bop_twop_number_in_m)):/bop_multif
bop_hh_age = (bop_alon_age,bop_onep_age,bop_twop_age,bop_multif_age,bop_mult_age,bop_cple_age)

bop_onep_age_growth[2..rows(bop_onep_age_growth)] = diff(bop_onep_age):/bop_onep_age[Time_length-1,.] 
bop_twop_age_growth[2..rows(bop_twop_age_growth)] = diff(bop_onep_age):/bop_onep_age[Time_length-1,.] 
bop_alon_age_growth[2..rows(bop_alon_age_growth)] = diff(bop_alon_age):/bop_alon_age[Time_length-1,.] 
bop_mult_age_growth[2..rows(bop_mult_age_growth)] = diff(bop_mult_age):/bop_mult_age[Time_length-1,.] 
bop_cple_age_growth[2..rows(bop_cple_age_growth)] = diff(bop_cple_age):/bop_cple_age[Time_length-1,.] 
bop_multif_age_growth[2..rows(bop_multif_age_growth)] = diff(bop_multif_age):/bop_multif_age[Time_length-1,.]  

/*TAR*/

/*(a) Project population by living arrangement*/

/*(i) first for each category of person and gender*/
tar_f_onep_c = tar_pop_fcast_f:*LATR_f[1..TL,.]
tar_f_twop_c = tar_pop_fcast_f:*LATR_f[1+TL*1..TL+TL*1,.]
tar_f_alon_a = tar_pop_fcast_f:*LATR_f[1+TL*2..TL+TL*2,.]
tar_f_mult_o = tar_pop_fcast_f:*LATR_f[1+TL*3..TL+TL*3,.]
tar_f_cple_o = tar_pop_fcast_f:*LATR_f[1+TL*4..TL+TL*4,.]
tar_f_onep_o = tar_pop_fcast_f:*LATR_f[1+TL*5..TL+TL*5,.]
tar_f_twop_o = tar_pop_fcast_f:*LATR_f[1+TL*6..TL+TL*6,.]
tar_f_onep_a = tar_pop_fcast_f:*LATR_f[1+TL*7..TL+TL*7,.]
tar_f_cple_a = tar_pop_fcast_f:*LATR_f[1+TL*8..TL+TL*8,.]
tar_f_twop_a = tar_pop_fcast_f:*LATR_f[1+TL*9..TL+TL*9,.]
tar_f_nonprv = tar_pop_fcast_f:*LATR_f[1+TL*10..TL+TL*10,.]
tar_m_onep_c = tar_pop_fcast_m:*LATR_m[1..TL,.]
tar_m_twop_c = tar_pop_fcast_m:*LATR_m[1+TL*1..TL+TL*1,.]
tar_m_alon_a = tar_pop_fcast_m:*LATR_m[1+TL*2..TL+TL*2,.]
tar_m_mult_o = tar_pop_fcast_m:*LATR_m[1+TL*3..TL+TL*3,.]
tar_m_cple_o = tar_pop_fcast_m:*LATR_m[1+TL*4..TL+TL*4,.]
tar_m_onep_o = tar_pop_fcast_m:*LATR_m[1+TL*5..TL+TL*5,.]
tar_m_twop_o = tar_pop_fcast_m:*LATR_m[1+TL*6..TL+TL*6,.]
tar_m_onep_a = tar_pop_fcast_m:*LATR_m[1+TL*7..TL+TL*7,.]
tar_m_cple_a = tar_pop_fcast_m:*LATR_m[1+TL*8..TL+TL*8,.]
tar_m_twop_a = tar_pop_fcast_m:*LATR_m[1+TL*9..TL+TL*9,.]
tar_m_nonprv = tar_pop_fcast_m:*LATR_m[1+TL*10..TL+TL*10,.]

/*(ii) then aggregating over gender*/
tar_onep_c = tar_f_onep_c + tar_m_onep_c
tar_twop_c = tar_f_twop_c + tar_m_twop_c
tar_alon_a = tar_f_alon_a + tar_m_alon_a
tar_mult_o = tar_f_mult_o + tar_m_mult_o
tar_cple_o = tar_f_cple_o + tar_m_cple_o
tar_onep_o = tar_f_onep_o + tar_m_onep_o 
tar_twop_o = tar_f_twop_o + tar_m_twop_o  
tar_onep_a = tar_f_onep_a + tar_m_onep_a 
tar_cple_a = tar_f_cple_a + tar_m_cple_a
tar_twop_a = tar_f_twop_a + tar_m_twop_a 
tar_nonprv = tar_f_nonprv + tar_m_nonprv 

/* (iii) then summing over family types to give number of people, by age, in each living arrangement/family type*/

tar_onep_all = (tar_onep_c + tar_onep_a + tar_onep_o):*J(1,Ages_n,1:-multif_onep)
tar_twop_all = (tar_twop_c + tar_twop_a + tar_twop_o):*J(1,Ages_n,1:-multif_twop)
tar_alon_all = tar_alon_a
tar_mult_all = tar_mult_o
tar_cple_all = tar_cple_a + tar_cple_o
tar_multif_all = (tar_onep_c + tar_onep_a + tar_onep_o)+(tar_twop_c + tar_twop_a + tar_twop_o)-(tar_onep_all + tar_twop_all)
tar_families = rowsum(tar_onep_a)+ rowsum(tar_cple_a)*0.5 + rowsum(tar_twop_a)*0.5
/*Household numbers*/
/*oneparent households*/
/*two parent households*/
/* multi family households*/
/*couple (no kids) households*/
/* sole person households*/
/*multi person households*/
/*non private dwelling i.e. not counted as a hh*/

tar_onep = (1:-multif_onep):*(rowsum(tar_onep_a))
tar_twop = (1:-multif_twop):*(rowsum(tar_twop_a)*0.5)
tar_onep_number_in_m = (multif_onep):*(rowsum(tar_onep_a))
tar_twop_number_in_m = ((multif_twop):*(rowsum(tar_twop_a)*0.5))
tar_multif = tar_onep_number_in_m + tar_twop_number_in_m 
tar_cple = rowsum(tar_cple_a)*0.5
tar_alon = rowsum(tar_alon_a) 
tar_multi = rowsum(tar_mult_o):/people_per_multi 
tar_nonhh = rowsum(tar_nonprv)


/*Household aggregates*/
/* this is the way statsnz calculates number of HH*/
/* this is the number of households consistent with the model*/

tar_households_aggr = tar_families:/fam_per_hh + rowsum(tar_mult_o):/people_per_multi + rowsum(tar_alon_a) 
tar_households = (tar_onep + tar_twop + tar_alon + tar_multif + tar_cple + tar_multi)
tar_people_per_hh = (tar_pop-tar_nonhh):/tar_households
tar_people_per_onep = (rowsum(tar_onep_c) + rowsum(tar_onep_a) + rowsum(tar_onep_o)):/rowsum(tar_onep_a)
tar_people_per_twop = (rowsum(tar_twop_c) + rowsum(tar_twop_a) + rowsum(tar_twop_o)):/(rowsum(tar_twop_a)*0.5)
tar_people_per_cple = (rowsum(tar_cple_a) + rowsum(tar_cple_o)):/tar_cple
tar_people_per_multif =  (((multif_onep):*(rowsum(tar_onep_a)+rowsum(tar_onep_c)+rowsum(tar_onep_o))) + ((multif_twop):*(rowsum(tar_twop_a)+rowsum(tar_twop_c)+rowsum(tar_twop_o)))):/tar_multif


tar_people_per_alon = J(TL,1,1)
tar_hh_size = (tar_people_per_alon,tar_people_per_onep,tar_people_per_twop,tar_people_per_multif,people_per_multi,tar_people_per_cple)
tar_hh_composition =(tar_alon,tar_onep,tar_twop,tar_multif,tar_multi,tar_cple)
tar_pop_by_hh_composition = tar_hh_composition:*tar_hh_size
tar_pop_by_hh_composition_shares = tar_pop_by_hh_composition:/J(1,6,tar_pop)

/*Average age of family units/LATRs and Households*/
/*assume no distinction in average age for thoe joining mutlifamily households*/
tar_onep_age = (tar_onep_all*Ages'):/(rowsum(tar_onep_all))
tar_twop_age = (tar_twop_all*Ages'):/(rowsum(tar_twop_all))
tar_alon_age = (tar_alon_all*Ages'):/(rowsum(tar_alon_all))
tar_mult_age = (tar_mult_all*Ages'):/(rowsum(tar_mult_all))
tar_cple_age = (tar_cple_all*Ages'):/(rowsum(tar_cple_all))
tar_multif_age = ((tar_onep_age:*tar_onep_number_in_m)+ (tar_twop_age:*tar_twop_number_in_m)):/tar_multif 
tar_hh_age = (tar_alon_age,tar_onep_age,tar_twop_age,tar_multif_age,tar_mult_age,tar_cple_age)

tar_onep_age_growth[2..rows(tar_onep_age_growth)] = diff(tar_onep_age):/tar_onep_age[Time_length-1,.] 
tar_twop_age_growth[2..rows(tar_twop_age_growth)] = diff(tar_onep_age):/tar_onep_age[Time_length-1,.] 
tar_alon_age_growth[2..rows(tar_alon_age_growth)] = diff(tar_alon_age):/tar_alon_age[Time_length-1,.] 
tar_mult_age_growth[2..rows(tar_mult_age_growth)] = diff(tar_mult_age):/tar_mult_age[Time_length-1,.] 
tar_cple_age_growth[2..rows(tar_cple_age_growth)] = diff(tar_cple_age):/tar_cple_age[Time_length-1,.] 
tar_multif_age_growth[2..rows(tar_multif_age_growth)] = diff(tar_multif_age):/tar_multif_age[Time_length-1,.]  

/*MAN*/

/*(a) Project population by living arrangement*/

/*(i) first for each category of person and gender*/
man_f_onep_c = man_pop_fcast_f:*LATR_f[1..TL,.]
man_f_twop_c = man_pop_fcast_f:*LATR_f[1+TL*1..TL+TL*1,.]
man_f_alon_a = man_pop_fcast_f:*LATR_f[1+TL*2..TL+TL*2,.]
man_f_mult_o = man_pop_fcast_f:*LATR_f[1+TL*3..TL+TL*3,.]
man_f_cple_o = man_pop_fcast_f:*LATR_f[1+TL*4..TL+TL*4,.]
man_f_onep_o = man_pop_fcast_f:*LATR_f[1+TL*5..TL+TL*5,.]
man_f_twop_o = man_pop_fcast_f:*LATR_f[1+TL*6..TL+TL*6,.]
man_f_onep_a = man_pop_fcast_f:*LATR_f[1+TL*7..TL+TL*7,.]
man_f_cple_a = man_pop_fcast_f:*LATR_f[1+TL*8..TL+TL*8,.]
man_f_twop_a = man_pop_fcast_f:*LATR_f[1+TL*9..TL+TL*9,.]
man_f_nonprv = man_pop_fcast_f:*LATR_f[1+TL*10..TL+TL*10,.]
man_m_onep_c = man_pop_fcast_m:*LATR_m[1..TL,.]
man_m_twop_c = man_pop_fcast_m:*LATR_m[1+TL*1..TL+TL*1,.]
man_m_alon_a = man_pop_fcast_m:*LATR_m[1+TL*2..TL+TL*2,.]
man_m_mult_o = man_pop_fcast_m:*LATR_m[1+TL*3..TL+TL*3,.]
man_m_cple_o = man_pop_fcast_m:*LATR_m[1+TL*4..TL+TL*4,.]
man_m_onep_o = man_pop_fcast_m:*LATR_m[1+TL*5..TL+TL*5,.]
man_m_twop_o = man_pop_fcast_m:*LATR_m[1+TL*6..TL+TL*6,.]
man_m_onep_a = man_pop_fcast_m:*LATR_m[1+TL*7..TL+TL*7,.]
man_m_cple_a = man_pop_fcast_m:*LATR_m[1+TL*8..TL+TL*8,.]
man_m_twop_a = man_pop_fcast_m:*LATR_m[1+TL*9..TL+TL*9,.]
man_m_nonprv = man_pop_fcast_m:*LATR_m[1+TL*10..TL+TL*10,.]

/*(ii) then aggregating over gender*/
man_onep_c = man_f_onep_c + man_m_onep_c
man_twop_c = man_f_twop_c + man_m_twop_c
man_alon_a = man_f_alon_a + man_m_alon_a
man_mult_o = man_f_mult_o + man_m_mult_o
man_cple_o = man_f_cple_o + man_m_cple_o
man_onep_o = man_f_onep_o + man_m_onep_o 
man_twop_o = man_f_twop_o + man_m_twop_o  
man_onep_a = man_f_onep_a + man_m_onep_a 
man_cple_a = man_f_cple_a + man_m_cple_a
man_twop_a = man_f_twop_a + man_m_twop_a 
man_nonprv = man_f_nonprv + man_m_nonprv 

/* (iii) then summing over family types to give number of people, by age, in each living arrangement/family type*/

man_onep_all = (man_onep_c + man_onep_a + man_onep_o):*J(1,Ages_n,1:-multif_onep)
man_twop_all = (man_twop_c + man_twop_a + man_twop_o):*J(1,Ages_n,1:-multif_twop)
man_alon_all = man_alon_a
man_mult_all = man_mult_o
man_cple_all = man_cple_a + man_cple_o
man_multif_all = (man_onep_c + man_onep_a + man_onep_o)+(man_twop_c + man_twop_a + man_twop_o)-(man_onep_all + man_twop_all)
man_families = rowsum(man_onep_a)+ rowsum(man_cple_a)*0.5 + rowsum(man_twop_a)*0.5
/*Household numbers*/
/*oneparent households*/
/*two parent households*/
/* multi family households*/
/*couple (no kids) households*/
/* sole person households*/
/*multi person households*/
/*non private dwelling i.e. not counted as a hh*/

man_onep = (1:-multif_onep):*(rowsum(man_onep_a))
man_twop = (1:-multif_twop):*(rowsum(man_twop_a)*0.5)
man_onep_number_in_m = (multif_onep):*(rowsum(man_onep_a))
man_twop_number_in_m = ((multif_twop):*(rowsum(man_twop_a)*0.5))
man_multif = man_onep_number_in_m + man_twop_number_in_m
man_cple = rowsum(man_cple_a)*0.5
man_alon = rowsum(man_alon_a) 
man_multi = rowsum(man_mult_o):/people_per_multi 
man_nonhh = rowsum(man_nonprv)


/*Household aggregates*/
/* this is the way statsnz calculates number of HH*/
/* this is the number of households consistent with the model*/

man_households_aggr = man_families:/fam_per_hh + rowsum(man_mult_o):/people_per_multi + rowsum(man_alon_a) 
man_households = (man_onep + man_twop + man_alon + man_multif + man_cple + man_multi)
man_people_per_hh = (man_pop-man_nonhh):/man_households
man_people_per_onep = (rowsum(man_onep_c) + rowsum(man_onep_a) + rowsum(man_onep_o)):/rowsum(man_onep_a)
man_people_per_twop = (rowsum(man_twop_c) + rowsum(man_twop_a) + rowsum(man_twop_o)):/(rowsum(man_twop_a)*0.5)
man_people_per_cple = (rowsum(man_cple_a) + rowsum(man_cple_o)):/man_cple
man_people_per_multif =  (((multif_onep):*(rowsum(man_onep_a)+rowsum(man_onep_c)+rowsum(man_onep_o))) + ((multif_twop):*(rowsum(man_twop_a)+rowsum(man_twop_c)+rowsum(man_twop_o)))):/man_multif


man_people_per_alon = J(TL,1,1)
man_hh_size = (man_people_per_alon,man_people_per_onep,man_people_per_twop,man_people_per_multif,people_per_multi,man_people_per_cple)
man_hh_composition =(man_alon,man_onep,man_twop,man_multif,man_multi,man_cple)
man_pop_by_hh_composition = man_hh_composition:*man_hh_size
man_pop_by_hh_composition_shares = man_pop_by_hh_composition:/J(1,6,man_pop)

/*Average age of family units/LATRs and Households*/
/*assume no distinction in average age for thoe joining mutlifamily households*/
man_onep_age = (man_onep_all*Ages'):/(rowsum(man_onep_all))
man_twop_age = (man_twop_all*Ages'):/(rowsum(man_twop_all))
man_alon_age = (man_alon_all*Ages'):/(rowsum(man_alon_all))
man_mult_age = (man_mult_all*Ages'):/(rowsum(man_mult_all))
man_cple_age = (man_cple_all*Ages'):/(rowsum(man_cple_all))
man_multif_age = ((man_onep_age:*man_onep_number_in_m)+ (man_twop_age:*man_twop_number_in_m)):/man_multif 
man_hh_age = (man_alon_age,man_onep_age,man_twop_age,man_multif_age,man_mult_age,man_cple_age)

man_onep_age_growth[2..rows(man_onep_age_growth)] = diff(man_onep_age):/man_onep_age[Time_length-1,.] 
man_twop_age_growth[2..rows(man_twop_age_growth)] = diff(man_onep_age):/man_onep_age[Time_length-1,.] 
man_alon_age_growth[2..rows(man_alon_age_growth)] = diff(man_alon_age):/man_alon_age[Time_length-1,.] 
man_mult_age_growth[2..rows(man_mult_age_growth)] = diff(man_mult_age):/man_mult_age[Time_length-1,.] 
man_cple_age_growth[2..rows(man_cple_age_growth)] = diff(man_cple_age):/man_cple_age[Time_length-1,.] 
man_multif_age_growth[2..rows(man_multif_age_growth)] = diff(man_multif_age):/man_multif_age[Time_length-1,.]  


/*WEL*/

/*(a) Project population by living arrangement*/

/*(i) first for each category of person and gender*/
wel_f_onep_c = wel_pop_fcast_f:*LATR_f[1..TL,.]
wel_f_twop_c = wel_pop_fcast_f:*LATR_f[1+TL*1..TL+TL*1,.]
wel_f_alon_a = wel_pop_fcast_f:*LATR_f[1+TL*2..TL+TL*2,.]
wel_f_mult_o = wel_pop_fcast_f:*LATR_f[1+TL*3..TL+TL*3,.]
wel_f_cple_o = wel_pop_fcast_f:*LATR_f[1+TL*4..TL+TL*4,.]
wel_f_onep_o = wel_pop_fcast_f:*LATR_f[1+TL*5..TL+TL*5,.]
wel_f_twop_o = wel_pop_fcast_f:*LATR_f[1+TL*6..TL+TL*6,.]
wel_f_onep_a = wel_pop_fcast_f:*LATR_f[1+TL*7..TL+TL*7,.]
wel_f_cple_a = wel_pop_fcast_f:*LATR_f[1+TL*8..TL+TL*8,.]
wel_f_twop_a = wel_pop_fcast_f:*LATR_f[1+TL*9..TL+TL*9,.]
wel_f_nonprv = wel_pop_fcast_f:*LATR_f[1+TL*10..TL+TL*10,.]
wel_m_onep_c = wel_pop_fcast_m:*LATR_m[1..TL,.]
wel_m_twop_c = wel_pop_fcast_m:*LATR_m[1+TL*1..TL+TL*1,.]
wel_m_alon_a = wel_pop_fcast_m:*LATR_m[1+TL*2..TL+TL*2,.]
wel_m_mult_o = wel_pop_fcast_m:*LATR_m[1+TL*3..TL+TL*3,.]
wel_m_cple_o = wel_pop_fcast_m:*LATR_m[1+TL*4..TL+TL*4,.]
wel_m_onep_o = wel_pop_fcast_m:*LATR_m[1+TL*5..TL+TL*5,.]
wel_m_twop_o = wel_pop_fcast_m:*LATR_m[1+TL*6..TL+TL*6,.]
wel_m_onep_a = wel_pop_fcast_m:*LATR_m[1+TL*7..TL+TL*7,.]
wel_m_cple_a = wel_pop_fcast_m:*LATR_m[1+TL*8..TL+TL*8,.]
wel_m_twop_a = wel_pop_fcast_m:*LATR_m[1+TL*9..TL+TL*9,.]
wel_m_nonprv = wel_pop_fcast_m:*LATR_m[1+TL*10..TL+TL*10,.]

/*(ii) then aggregating over gender*/
wel_onep_c = wel_f_onep_c + wel_m_onep_c
wel_twop_c = wel_f_twop_c + wel_m_twop_c
wel_alon_a = wel_f_alon_a + wel_m_alon_a
wel_mult_o = wel_f_mult_o + wel_m_mult_o
wel_cple_o = wel_f_cple_o + wel_m_cple_o
wel_onep_o = wel_f_onep_o + wel_m_onep_o 
wel_twop_o = wel_f_twop_o + wel_m_twop_o  
wel_onep_a = wel_f_onep_a + wel_m_onep_a 
wel_cple_a = wel_f_cple_a + wel_m_cple_a
wel_twop_a = wel_f_twop_a + wel_m_twop_a 
wel_nonprv = wel_f_nonprv + wel_m_nonprv 

/* (iii) then summing over family types to give number of people, by age, in each living arrangement/family type*/

wel_onep_all = (wel_onep_c + wel_onep_a + wel_onep_o):*J(1,Ages_n,1:-multif_onep)
wel_twop_all = (wel_twop_c + wel_twop_a + wel_twop_o):*J(1,Ages_n,1:-multif_twop)
wel_alon_all = wel_alon_a
wel_mult_all = wel_mult_o
wel_cple_all = wel_cple_a + wel_cple_o
wel_multif_all = (wel_onep_c + wel_onep_a + wel_onep_o)+(wel_twop_c + wel_twop_a + wel_twop_o)-(wel_onep_all + wel_twop_all)
wel_families = rowsum(wel_onep_a)+ rowsum(wel_cple_a)*0.5 + rowsum(wel_twop_a)*0.5
/*Household numbers*/
/*oneparent households*/
/*two parent households*/
/* multi family households*/
/*couple (no kids) households*/
/* sole person households*/
/*multi person households*/
/*non private dwelling i.e. not counted as a hh*/

wel_onep = (1:-multif_onep):*(rowsum(wel_onep_a))
wel_twop = (1:-multif_twop):*(rowsum(wel_twop_a)*0.5)
wel_onep_number_in_m = (multif_onep):*(rowsum(wel_onep_a))
wel_twop_number_in_m = ((multif_twop):*(rowsum(wel_twop_a)*0.5))
wel_multif = wel_onep_number_in_m + wel_twop_number_in_m 
wel_cple = rowsum(wel_cple_a)*0.5
wel_alon = rowsum(wel_alon_a) 
wel_multi = rowsum(wel_mult_o):/people_per_multi 
wel_nonhh = rowsum(wel_nonprv)


/*Household aggregates*/
/* this is the way statsnz calculates number of HH*/
/* this is the number of households consistent with the model*/

wel_households_aggr = wel_families:/fam_per_hh + rowsum(wel_mult_o):/people_per_multi + rowsum(wel_alon_a) 
wel_households = (wel_onep + wel_twop + wel_alon + wel_multif + wel_cple + wel_multi)
wel_people_per_hh = (wel_pop-wel_nonhh):/wel_households
wel_people_per_onep = (rowsum(wel_onep_c) + rowsum(wel_onep_a) + rowsum(wel_onep_o)):/rowsum(wel_onep_a)
wel_people_per_twop = (rowsum(wel_twop_c) + rowsum(wel_twop_a) + rowsum(wel_twop_o)):/(rowsum(wel_twop_a)*0.5)
wel_people_per_cple = (rowsum(wel_cple_a) + rowsum(wel_cple_o)):/wel_cple
wel_people_per_multif =  (((multif_onep):*(rowsum(wel_onep_a)+rowsum(wel_onep_c)+rowsum(wel_onep_o))) + ((multif_twop):*(rowsum(wel_twop_a)+rowsum(wel_twop_c)+rowsum(wel_twop_o)))):/wel_multif


wel_people_per_alon = J(TL,1,1)
wel_hh_size = (wel_people_per_alon,wel_people_per_onep,wel_people_per_twop,wel_people_per_multif,people_per_multi,wel_people_per_cple)
wel_hh_composition =(wel_alon,wel_onep,wel_twop,wel_multif,wel_multi,wel_cple)
wel_pop_by_hh_composition = wel_hh_composition:*wel_hh_size
wel_pop_by_hh_composition_shares = wel_pop_by_hh_composition:/J(1,6,wel_pop)

/*Average age of family units/LATRs and Households*/
/*assume no distinction in average age for thoe joining mutlifamily households*/
wel_onep_age = (wel_onep_all*Ages'):/(rowsum(wel_onep_all))
wel_twop_age = (wel_twop_all*Ages'):/(rowsum(wel_twop_all))
wel_alon_age = (wel_alon_all*Ages'):/(rowsum(wel_alon_all))
wel_mult_age = (wel_mult_all*Ages'):/(rowsum(wel_mult_all))
wel_cple_age = (wel_cple_all*Ages'):/(rowsum(wel_cple_all))
wel_multif_age = ((wel_onep_age:*wel_onep_number_in_m)+ (wel_twop_age:*wel_twop_number_in_m)):/wel_multif 
wel_hh_age = (wel_alon_age,wel_onep_age,wel_twop_age,wel_multif_age,wel_mult_age,wel_cple_age)

wel_onep_age_growth[2..rows(wel_onep_age_growth)] = diff(wel_onep_age):/wel_onep_age[Time_length-1,.] 
wel_twop_age_growth[2..rows(wel_twop_age_growth)] = diff(wel_onep_age):/wel_onep_age[Time_length-1,.] 
wel_alon_age_growth[2..rows(wel_alon_age_growth)] = diff(wel_alon_age):/wel_alon_age[Time_length-1,.] 
wel_mult_age_growth[2..rows(wel_mult_age_growth)] = diff(wel_mult_age):/wel_mult_age[Time_length-1,.] 
wel_cple_age_growth[2..rows(wel_cple_age_growth)] = diff(wel_cple_age):/wel_cple_age[Time_length-1,.] 
wel_multif_age_growth[2..rows(wel_multif_age_growth)] = diff(wel_multif_age):/wel_multif_age[Time_length-1,.]  


/*CAN*/

/*(a) Project population by living arrangement*/

/*(i) first for each category of person and gender*/
can_f_onep_c = can_pop_fcast_f:*LATR_f[1..TL,.]
can_f_twop_c = can_pop_fcast_f:*LATR_f[1+TL*1..TL+TL*1,.]
can_f_alon_a = can_pop_fcast_f:*LATR_f[1+TL*2..TL+TL*2,.]
can_f_mult_o = can_pop_fcast_f:*LATR_f[1+TL*3..TL+TL*3,.]
can_f_cple_o = can_pop_fcast_f:*LATR_f[1+TL*4..TL+TL*4,.]
can_f_onep_o = can_pop_fcast_f:*LATR_f[1+TL*5..TL+TL*5,.]
can_f_twop_o = can_pop_fcast_f:*LATR_f[1+TL*6..TL+TL*6,.]
can_f_onep_a = can_pop_fcast_f:*LATR_f[1+TL*7..TL+TL*7,.]
can_f_cple_a = can_pop_fcast_f:*LATR_f[1+TL*8..TL+TL*8,.]
can_f_twop_a = can_pop_fcast_f:*LATR_f[1+TL*9..TL+TL*9,.]
can_f_nonprv = can_pop_fcast_f:*LATR_f[1+TL*10..TL+TL*10,.]
can_m_onep_c = can_pop_fcast_m:*LATR_m[1..TL,.]
can_m_twop_c = can_pop_fcast_m:*LATR_m[1+TL*1..TL+TL*1,.]
can_m_alon_a = can_pop_fcast_m:*LATR_m[1+TL*2..TL+TL*2,.]
can_m_mult_o = can_pop_fcast_m:*LATR_m[1+TL*3..TL+TL*3,.]
can_m_cple_o = can_pop_fcast_m:*LATR_m[1+TL*4..TL+TL*4,.]
can_m_onep_o = can_pop_fcast_m:*LATR_m[1+TL*5..TL+TL*5,.]
can_m_twop_o = can_pop_fcast_m:*LATR_m[1+TL*6..TL+TL*6,.]
can_m_onep_a = can_pop_fcast_m:*LATR_m[1+TL*7..TL+TL*7,.]
can_m_cple_a = can_pop_fcast_m:*LATR_m[1+TL*8..TL+TL*8,.]
can_m_twop_a = can_pop_fcast_m:*LATR_m[1+TL*9..TL+TL*9,.]
can_m_nonprv = can_pop_fcast_m:*LATR_m[1+TL*10..TL+TL*10,.]

/*(ii) then aggregating over gender*/
can_onep_c = can_f_onep_c + can_m_onep_c
can_twop_c = can_f_twop_c + can_m_twop_c
can_alon_a = can_f_alon_a + can_m_alon_a
can_mult_o = can_f_mult_o + can_m_mult_o
can_cple_o = can_f_cple_o + can_m_cple_o
can_onep_o = can_f_onep_o + can_m_onep_o 
can_twop_o = can_f_twop_o + can_m_twop_o  
can_onep_a = can_f_onep_a + can_m_onep_a 
can_cple_a = can_f_cple_a + can_m_cple_a
can_twop_a = can_f_twop_a + can_m_twop_a 
can_nonprv = can_f_nonprv + can_m_nonprv 

/* (iii) then summing over family types to give number of people, by age, in each living arrangement/family type*/

can_onep_all = (can_onep_c + can_onep_a + can_onep_o):*J(1,Ages_n,1:-multif_onep)
can_twop_all = (can_twop_c + can_twop_a + can_twop_o):*J(1,Ages_n,1:-multif_twop)
can_alon_all = can_alon_a
can_mult_all = can_mult_o
can_cple_all = can_cple_a + can_cple_o
can_multif_all = (can_onep_c + can_onep_a + can_onep_o)+(can_twop_c + can_twop_a + can_twop_o)-(can_onep_all + can_twop_all)
can_families = rowsum(can_onep_a)+ rowsum(can_cple_a)*0.5 + rowsum(can_twop_a)*0.5
/*Household numbers*/
/*oneparent households*/
/*two parent households*/
/* multi family households*/
/*couple (no kids) households*/
/* sole person households*/
/*multi person households*/
/*non private dwelling i.e. not counted as a hh*/

can_onep = (1:-multif_onep):*(rowsum(can_onep_a))
can_twop = (1:-multif_twop):*(rowsum(can_twop_a)*0.5)
can_onep_number_in_m = (multif_onep):*(rowsum(can_onep_a))
can_twop_number_in_m = ((multif_twop):*(rowsum(can_twop_a)*0.5))
can_multif = can_onep_number_in_m + can_twop_number_in_m 
can_cple = rowsum(can_cple_a)*0.5
can_alon = rowsum(can_alon_a) 
can_multi = rowsum(can_mult_o):/people_per_multi 
can_nonhh = rowsum(can_nonprv)


/*Household aggregates*/
/* this is the way statsnz calculates number of HH*/
/* this is the number of households consistent with the model*/

can_households_aggr = can_families:/fam_per_hh + rowsum(can_mult_o):/people_per_multi + rowsum(can_alon_a) 
can_households = (can_onep + can_twop + can_alon + can_multif + can_cple + can_multi)
can_people_per_hh = (can_pop-can_nonhh):/can_households
can_people_per_onep = (rowsum(can_onep_c) + rowsum(can_onep_a) + rowsum(can_onep_o)):/rowsum(can_onep_a)
can_people_per_twop = (rowsum(can_twop_c) + rowsum(can_twop_a) + rowsum(can_twop_o)):/(rowsum(can_twop_a)*0.5)
can_people_per_cple = (rowsum(can_cple_a) + rowsum(can_cple_o)):/can_cple
can_people_per_multif =  (((multif_onep):*(rowsum(can_onep_a)+rowsum(can_onep_c)+rowsum(can_onep_o))) + ((multif_twop):*(rowsum(can_twop_a)+rowsum(can_twop_c)+rowsum(can_twop_o)))):/can_multif


can_people_per_alon = J(TL,1,1)
can_hh_size = (can_people_per_alon,can_people_per_onep,can_people_per_twop,can_people_per_multif,people_per_multi,can_people_per_cple)
can_hh_composition =(can_alon,can_onep,can_twop,can_multif,can_multi,can_cple)
can_pop_by_hh_composition = can_hh_composition:*can_hh_size
can_pop_by_hh_composition_shares = can_pop_by_hh_composition:/J(1,6,can_pop)

/*Average age of family units/LATRs and Households*/
/*assume no distinction in average age for thoe joining mutlifamily households*/
can_onep_age = (can_onep_all*Ages'):/(rowsum(can_onep_all))
can_twop_age = (can_twop_all*Ages'):/(rowsum(can_twop_all))
can_alon_age = (can_alon_all*Ages'):/(rowsum(can_alon_all))
can_mult_age = (can_mult_all*Ages'):/(rowsum(can_mult_all))
can_cple_age = (can_cple_all*Ages'):/(rowsum(can_cple_all))
can_multif_age = ((can_onep_age:*can_onep_number_in_m)+ (can_twop_age:*can_twop_number_in_m)):/can_multif 
can_hh_age = (can_alon_age,can_onep_age,can_twop_age,can_multif_age,can_mult_age,can_cple_age)

can_onep_age_growth[2..rows(can_onep_age_growth)] = diff(can_onep_age):/can_onep_age[Time_length-1,.] 
can_twop_age_growth[2..rows(can_twop_age_growth)] = diff(can_onep_age):/can_onep_age[Time_length-1,.] 
can_alon_age_growth[2..rows(can_alon_age_growth)] = diff(can_alon_age):/can_alon_age[Time_length-1,.] 
can_mult_age_growth[2..rows(can_mult_age_growth)] = diff(can_mult_age):/can_mult_age[Time_length-1,.] 
can_cple_age_growth[2..rows(can_cple_age_growth)] = diff(can_cple_age):/can_cple_age[Time_length-1,.] 
can_multif_age_growth[2..rows(can_multif_age_growth)] = diff(can_multif_age):/can_multif_age[Time_length-1,.]  


/*OTG*/

/*(a) Project population by living arrangement*/

/*(i) first for each category of person and gender*/
otg_f_onep_c = otg_pop_fcast_f:*LATR_f[1..TL,.]
otg_f_twop_c = otg_pop_fcast_f:*LATR_f[1+TL*1..TL+TL*1,.]
otg_f_alon_a = otg_pop_fcast_f:*LATR_f[1+TL*2..TL+TL*2,.]
otg_f_mult_o = otg_pop_fcast_f:*LATR_f[1+TL*3..TL+TL*3,.]
otg_f_cple_o = otg_pop_fcast_f:*LATR_f[1+TL*4..TL+TL*4,.]
otg_f_onep_o = otg_pop_fcast_f:*LATR_f[1+TL*5..TL+TL*5,.]
otg_f_twop_o = otg_pop_fcast_f:*LATR_f[1+TL*6..TL+TL*6,.]
otg_f_onep_a = otg_pop_fcast_f:*LATR_f[1+TL*7..TL+TL*7,.]
otg_f_cple_a = otg_pop_fcast_f:*LATR_f[1+TL*8..TL+TL*8,.]
otg_f_twop_a = otg_pop_fcast_f:*LATR_f[1+TL*9..TL+TL*9,.]
otg_f_nonprv = otg_pop_fcast_f:*LATR_f[1+TL*10..TL+TL*10,.]
otg_m_onep_c = otg_pop_fcast_m:*LATR_m[1..TL,.]
otg_m_twop_c = otg_pop_fcast_m:*LATR_m[1+TL*1..TL+TL*1,.]
otg_m_alon_a = otg_pop_fcast_m:*LATR_m[1+TL*2..TL+TL*2,.]
otg_m_mult_o = otg_pop_fcast_m:*LATR_m[1+TL*3..TL+TL*3,.]
otg_m_cple_o = otg_pop_fcast_m:*LATR_m[1+TL*4..TL+TL*4,.]
otg_m_onep_o = otg_pop_fcast_m:*LATR_m[1+TL*5..TL+TL*5,.]
otg_m_twop_o = otg_pop_fcast_m:*LATR_m[1+TL*6..TL+TL*6,.]
otg_m_onep_a = otg_pop_fcast_m:*LATR_m[1+TL*7..TL+TL*7,.]
otg_m_cple_a = otg_pop_fcast_m:*LATR_m[1+TL*8..TL+TL*8,.]
otg_m_twop_a = otg_pop_fcast_m:*LATR_m[1+TL*9..TL+TL*9,.]
otg_m_nonprv = otg_pop_fcast_m:*LATR_m[1+TL*10..TL+TL*10,.]

/*(ii) then aggregating over gender*/
otg_onep_c = otg_f_onep_c + otg_m_onep_c
otg_twop_c = otg_f_twop_c + otg_m_twop_c
otg_alon_a = otg_f_alon_a + otg_m_alon_a
otg_mult_o = otg_f_mult_o + otg_m_mult_o
otg_cple_o = otg_f_cple_o + otg_m_cple_o
otg_onep_o = otg_f_onep_o + otg_m_onep_o 
otg_twop_o = otg_f_twop_o + otg_m_twop_o  
otg_onep_a = otg_f_onep_a + otg_m_onep_a 
otg_cple_a = otg_f_cple_a + otg_m_cple_a
otg_twop_a = otg_f_twop_a + otg_m_twop_a 
otg_nonprv = otg_f_nonprv + otg_m_nonprv 

/* (iii) then summing over family types to give number of people, by age, in each living arrangement/family type*/

otg_onep_all = (otg_onep_c + otg_onep_a + otg_onep_o):*J(1,Ages_n,1:-multif_onep)
otg_twop_all = (otg_twop_c + otg_twop_a + otg_twop_o):*J(1,Ages_n,1:-multif_twop)
otg_alon_all = otg_alon_a
otg_mult_all = otg_mult_o
otg_cple_all = otg_cple_a + otg_cple_o
otg_multif_all = (otg_onep_c + otg_onep_a + otg_onep_o)+(otg_twop_c + otg_twop_a + otg_twop_o)-(otg_onep_all + otg_twop_all)
otg_families = rowsum(otg_onep_a)+ rowsum(otg_cple_a)*0.5 + rowsum(otg_twop_a)*0.5
/*Household numbers*/
/*oneparent households*/
/*two parent households*/
/* multi family households*/
/*couple (no kids) households*/
/* sole person households*/
/*multi person households*/
/*non private dwelling i.e. not counted as a hh*/

otg_onep = (1:-multif_onep):*(rowsum(otg_onep_a))
otg_twop = (1:-multif_twop):*(rowsum(otg_twop_a)*0.5)
otg_onep_number_in_m = (multif_onep):*(rowsum(otg_onep_a))
otg_twop_number_in_m = ((multif_twop):*(rowsum(otg_twop_a)*0.5))
otg_multif = otg_onep_number_in_m + otg_twop_number_in_m 
otg_cple = rowsum(otg_cple_a)*0.5
otg_alon = rowsum(otg_alon_a) 
otg_multi = rowsum(otg_mult_o):/people_per_multi 
otg_nonhh = rowsum(otg_nonprv)


/*Household aggregates*/
/* this is the way statsnz calculates number of HH*/
/* this is the number of households consistent with the model*/

otg_households_aggr = otg_families:/fam_per_hh + rowsum(otg_mult_o):/people_per_multi + rowsum(otg_alon_a) 
otg_households = (otg_onep + otg_twop + otg_alon + otg_multif + otg_cple + otg_multi)
otg_people_per_hh = (otg_pop-otg_nonhh):/otg_households
otg_people_per_onep = (rowsum(otg_onep_c) + rowsum(otg_onep_a) + rowsum(otg_onep_o)):/rowsum(otg_onep_a)
otg_people_per_twop = (rowsum(otg_twop_c) + rowsum(otg_twop_a) + rowsum(otg_twop_o)):/(rowsum(otg_twop_a)*0.5)
otg_people_per_cple = (rowsum(otg_cple_a) + rowsum(otg_cple_o)):/otg_cple
otg_people_per_multif =  (((multif_onep):*(rowsum(otg_onep_a)+rowsum(otg_onep_c)+rowsum(otg_onep_o))) + ((multif_twop):*(rowsum(otg_twop_a)+rowsum(otg_twop_c)+rowsum(otg_twop_o)))):/otg_multif


otg_people_per_alon = J(TL,1,1)
otg_hh_size = (otg_people_per_alon,otg_people_per_onep,otg_people_per_twop,otg_people_per_multif,people_per_multi,otg_people_per_cple)
otg_hh_composition =(otg_alon,otg_onep,otg_twop,otg_multif,otg_multi,otg_cple)
otg_pop_by_hh_composition = otg_hh_composition:*otg_hh_size
otg_pop_by_hh_composition_shares = otg_pop_by_hh_composition:/J(1,6,otg_pop)

/*Average age of family units/LATRs and Households*/
/*assume no distinction in average age for thoe joining mutlifamily households*/
otg_onep_age = (otg_onep_all*Ages'):/(rowsum(otg_onep_all))
otg_twop_age = (otg_twop_all*Ages'):/(rowsum(otg_twop_all))
otg_alon_age = (otg_alon_all*Ages'):/(rowsum(otg_alon_all))
otg_mult_age = (otg_mult_all*Ages'):/(rowsum(otg_mult_all))
otg_cple_age = (otg_cple_all*Ages'):/(rowsum(otg_cple_all))
otg_multif_age = ((otg_onep_age:*otg_onep_number_in_m)+ (otg_twop_age:*otg_twop_number_in_m)):/otg_multif 
otg_hh_age = (otg_alon_age,otg_onep_age,otg_twop_age,otg_multif_age,otg_mult_age,otg_cple_age)

otg_onep_age_growth[2..rows(otg_onep_age_growth)] = diff(otg_onep_age):/otg_onep_age[Time_length-1,.] 
otg_twop_age_growth[2..rows(otg_twop_age_growth)] = diff(otg_onep_age):/otg_onep_age[Time_length-1,.] 
otg_alon_age_growth[2..rows(otg_alon_age_growth)] = diff(otg_alon_age):/otg_alon_age[Time_length-1,.] 
otg_mult_age_growth[2..rows(otg_mult_age_growth)] = diff(otg_mult_age):/otg_mult_age[Time_length-1,.] 
otg_cple_age_growth[2..rows(otg_cple_age_growth)] = diff(otg_cple_age):/otg_cple_age[Time_length-1,.] 
otg_multif_age_growth[2..rows(otg_multif_age_growth)] = diff(otg_multif_age):/otg_multif_age[Time_length-1,.]  

/*STH*/

/*(a) Project population by living arrangement*/

/*(i) first for each category of person and gender*/
sth_f_onep_c = sth_pop_fcast_f:*LATR_f[1..TL,.]
sth_f_twop_c = sth_pop_fcast_f:*LATR_f[1+TL*1..TL+TL*1,.]
sth_f_alon_a = sth_pop_fcast_f:*LATR_f[1+TL*2..TL+TL*2,.]
sth_f_mult_o = sth_pop_fcast_f:*LATR_f[1+TL*3..TL+TL*3,.]
sth_f_cple_o = sth_pop_fcast_f:*LATR_f[1+TL*4..TL+TL*4,.]
sth_f_onep_o = sth_pop_fcast_f:*LATR_f[1+TL*5..TL+TL*5,.]
sth_f_twop_o = sth_pop_fcast_f:*LATR_f[1+TL*6..TL+TL*6,.]
sth_f_onep_a = sth_pop_fcast_f:*LATR_f[1+TL*7..TL+TL*7,.]
sth_f_cple_a = sth_pop_fcast_f:*LATR_f[1+TL*8..TL+TL*8,.]
sth_f_twop_a = sth_pop_fcast_f:*LATR_f[1+TL*9..TL+TL*9,.]
sth_f_nonprv = sth_pop_fcast_f:*LATR_f[1+TL*10..TL+TL*10,.]
sth_m_onep_c = sth_pop_fcast_m:*LATR_m[1..TL,.]
sth_m_twop_c = sth_pop_fcast_m:*LATR_m[1+TL*1..TL+TL*1,.]
sth_m_alon_a = sth_pop_fcast_m:*LATR_m[1+TL*2..TL+TL*2,.]
sth_m_mult_o = sth_pop_fcast_m:*LATR_m[1+TL*3..TL+TL*3,.]
sth_m_cple_o = sth_pop_fcast_m:*LATR_m[1+TL*4..TL+TL*4,.]
sth_m_onep_o = sth_pop_fcast_m:*LATR_m[1+TL*5..TL+TL*5,.]
sth_m_twop_o = sth_pop_fcast_m:*LATR_m[1+TL*6..TL+TL*6,.]
sth_m_onep_a = sth_pop_fcast_m:*LATR_m[1+TL*7..TL+TL*7,.]
sth_m_cple_a = sth_pop_fcast_m:*LATR_m[1+TL*8..TL+TL*8,.]
sth_m_twop_a = sth_pop_fcast_m:*LATR_m[1+TL*9..TL+TL*9,.]
sth_m_nonprv = sth_pop_fcast_m:*LATR_m[1+TL*10..TL+TL*10,.]

/*(ii) then aggregating over gender*/
sth_onep_c = sth_f_onep_c + sth_m_onep_c
sth_twop_c = sth_f_twop_c + sth_m_twop_c
sth_alon_a = sth_f_alon_a + sth_m_alon_a
sth_mult_o = sth_f_mult_o + sth_m_mult_o
sth_cple_o = sth_f_cple_o + sth_m_cple_o
sth_onep_o = sth_f_onep_o + sth_m_onep_o 
sth_twop_o = sth_f_twop_o + sth_m_twop_o  
sth_onep_a = sth_f_onep_a + sth_m_onep_a 
sth_cple_a = sth_f_cple_a + sth_m_cple_a
sth_twop_a = sth_f_twop_a + sth_m_twop_a 
sth_nonprv = sth_f_nonprv + sth_m_nonprv 

/* (iii) then summing over family types to give number of people, by age, in each living arrangement/family type*/

sth_onep_all = (sth_onep_c + sth_onep_a + sth_onep_o):*J(1,Ages_n,1:-multif_onep)
sth_twop_all = (sth_twop_c + sth_twop_a + sth_twop_o):*J(1,Ages_n,1:-multif_twop)
sth_alon_all = sth_alon_a
sth_mult_all = sth_mult_o
sth_cple_all = sth_cple_a + sth_cple_o
sth_multif_all = (sth_onep_c + sth_onep_a + sth_onep_o)+(sth_twop_c + sth_twop_a + sth_twop_o)-(sth_onep_all + sth_twop_all)
sth_families = rowsum(sth_onep_a)+ rowsum(sth_cple_a)*0.5 + rowsum(sth_twop_a)*0.5
/*Household numbers*/
/*oneparent households*/
/*two parent households*/
/* multi family households*/
/*couple (no kids) households*/
/* sole person households*/
/*multi person households*/
/*non private dwelling i.e. not counted as a hh*/

sth_onep = (1:-multif_onep):*(rowsum(sth_onep_a))
sth_twop = (1:-multif_twop):*(rowsum(sth_twop_a)*0.5)
sth_onep_number_in_m = (multif_onep):*(rowsum(sth_onep_a))
sth_twop_number_in_m = ((multif_twop):*(rowsum(sth_twop_a)*0.5))
sth_multif = sth_onep_number_in_m + sth_twop_number_in_m 
sth_cple = rowsum(sth_cple_a)*0.5
sth_alon = rowsum(sth_alon_a) 
sth_multi = rowsum(sth_mult_o):/people_per_multi 
sth_nonhh = rowsum(sth_nonprv)


/*Household aggregates*/
/* this is the way statsnz calculates number of HH*/
/* this is the number of households consistent with the model*/

sth_households_aggr = sth_families:/fam_per_hh + rowsum(sth_mult_o):/people_per_multi + rowsum(sth_alon_a) 
sth_households = (sth_onep + sth_twop + sth_alon + sth_multif + sth_cple + sth_multi)
sth_people_per_hh = (sth_pop-sth_nonhh):/sth_households
sth_people_per_onep = (rowsum(sth_onep_c) + rowsum(sth_onep_a) + rowsum(sth_onep_o)):/rowsum(sth_onep_a)
sth_people_per_twop = (rowsum(sth_twop_c) + rowsum(sth_twop_a) + rowsum(sth_twop_o)):/(rowsum(sth_twop_a)*0.5)
sth_people_per_cple = (rowsum(sth_cple_a) + rowsum(sth_cple_o)):/sth_cple
sth_people_per_multif =  (((multif_onep):*(rowsum(sth_onep_a)+rowsum(sth_onep_c)+rowsum(sth_onep_o))) + ((multif_twop):*(rowsum(sth_twop_a)+rowsum(sth_twop_c)+rowsum(sth_twop_o)))):/sth_multif


sth_people_per_alon = J(TL,1,1)
sth_hh_size = (sth_people_per_alon,sth_people_per_onep,sth_people_per_twop,sth_people_per_multif,people_per_multi,sth_people_per_cple)
sth_hh_composition =(sth_alon,sth_onep,sth_twop,sth_multif,sth_multi,sth_cple)
sth_pop_by_hh_composition = sth_hh_composition:*sth_hh_size
sth_pop_by_hh_composition_shares = sth_pop_by_hh_composition:/J(1,6,sth_pop)

/*Average age of family units/LATRs and Households*/
/*assume no distinction in average age for thoe joining mutlifamily households*/
sth_onep_age = (sth_onep_all*Ages'):/(rowsum(sth_onep_all))
sth_twop_age = (sth_twop_all*Ages'):/(rowsum(sth_twop_all))
sth_alon_age = (sth_alon_all*Ages'):/(rowsum(sth_alon_all))
sth_mult_age = (sth_mult_all*Ages'):/(rowsum(sth_mult_all))
sth_cple_age = (sth_cple_all*Ages'):/(rowsum(sth_cple_all))
sth_multif_age = ((sth_onep_age:*sth_onep_number_in_m)+ (sth_twop_age:*sth_twop_number_in_m)):/sth_multif 
sth_hh_age = (sth_alon_age,sth_onep_age,sth_twop_age,sth_multif_age,sth_mult_age,sth_cple_age)

sth_onep_age_growth[2..rows(sth_onep_age_growth)] = diff(sth_onep_age):/sth_onep_age[Time_length-1,.]
sth_twop_age_growth[2..rows(sth_twop_age_growth)] = diff(sth_onep_age):/sth_onep_age[Time_length-1,.]
sth_alon_age_growth[2..rows(sth_alon_age_growth)] = diff(sth_alon_age):/sth_alon_age[Time_length-1,.]
sth_mult_age_growth[2..rows(sth_mult_age_growth)] = diff(sth_mult_age):/sth_mult_age[Time_length-1,.]
sth_cple_age_growth[2..rows(sth_cple_age_growth)] = diff(sth_cple_age):/sth_cple_age[Time_length-1,.]
sth_multif_age_growth[2..rows(sth_multif_age_growth)] = diff(sth_multif_age):/sth_multif_age[Time_length-1,.]  


/*GIS*/

/*(a) Project population by living arrangement*/

/*(i) first for each category of person and gender*/
gis_f_onep_c = gis_pop_fcast_f:*LATR_f[1..TL,.]
gis_f_twop_c = gis_pop_fcast_f:*LATR_f[1+TL*1..TL+TL*1,.]
gis_f_alon_a = gis_pop_fcast_f:*LATR_f[1+TL*2..TL+TL*2,.]
gis_f_mult_o = gis_pop_fcast_f:*LATR_f[1+TL*3..TL+TL*3,.]
gis_f_cple_o = gis_pop_fcast_f:*LATR_f[1+TL*4..TL+TL*4,.]
gis_f_onep_o = gis_pop_fcast_f:*LATR_f[1+TL*5..TL+TL*5,.]
gis_f_twop_o = gis_pop_fcast_f:*LATR_f[1+TL*6..TL+TL*6,.]
gis_f_onep_a = gis_pop_fcast_f:*LATR_f[1+TL*7..TL+TL*7,.]
gis_f_cple_a = gis_pop_fcast_f:*LATR_f[1+TL*8..TL+TL*8,.]
gis_f_twop_a = gis_pop_fcast_f:*LATR_f[1+TL*9..TL+TL*9,.]
gis_f_nonprv = gis_pop_fcast_f:*LATR_f[1+TL*10..TL+TL*10,.]
gis_m_onep_c = gis_pop_fcast_m:*LATR_m[1..TL,.]
gis_m_twop_c = gis_pop_fcast_m:*LATR_m[1+TL*1..TL+TL*1,.]
gis_m_alon_a = gis_pop_fcast_m:*LATR_m[1+TL*2..TL+TL*2,.]
gis_m_mult_o = gis_pop_fcast_m:*LATR_m[1+TL*3..TL+TL*3,.]
gis_m_cple_o = gis_pop_fcast_m:*LATR_m[1+TL*4..TL+TL*4,.]
gis_m_onep_o = gis_pop_fcast_m:*LATR_m[1+TL*5..TL+TL*5,.]
gis_m_twop_o = gis_pop_fcast_m:*LATR_m[1+TL*6..TL+TL*6,.]
gis_m_onep_a = gis_pop_fcast_m:*LATR_m[1+TL*7..TL+TL*7,.]
gis_m_cple_a = gis_pop_fcast_m:*LATR_m[1+TL*8..TL+TL*8,.]
gis_m_twop_a = gis_pop_fcast_m:*LATR_m[1+TL*9..TL+TL*9,.]
gis_m_nonprv = gis_pop_fcast_m:*LATR_m[1+TL*10..TL+TL*10,.]

/*(ii) then aggregating over gender*/
gis_onep_c = gis_f_onep_c + gis_m_onep_c
gis_twop_c = gis_f_twop_c + gis_m_twop_c
gis_alon_a = gis_f_alon_a + gis_m_alon_a
gis_mult_o = gis_f_mult_o + gis_m_mult_o
gis_cple_o = gis_f_cple_o + gis_m_cple_o
gis_onep_o = gis_f_onep_o + gis_m_onep_o 
gis_twop_o = gis_f_twop_o + gis_m_twop_o  
gis_onep_a = gis_f_onep_a + gis_m_onep_a 
gis_cple_a = gis_f_cple_a + gis_m_cple_a
gis_twop_a = gis_f_twop_a + gis_m_twop_a 
gis_nonprv = gis_f_nonprv + gis_m_nonprv 

/* (iii) then summing over family types to give number of people, by age, in each living arrangement/family type*/

gis_onep_all = (gis_onep_c + gis_onep_a + gis_onep_o):*J(1,Ages_n,1:-multif_onep)
gis_twop_all = (gis_twop_c + gis_twop_a + gis_twop_o):*J(1,Ages_n,1:-multif_twop)
gis_alon_all = gis_alon_a
gis_mult_all = gis_mult_o
gis_cple_all = gis_cple_a + gis_cple_o
gis_multif_all = (gis_onep_c + gis_onep_a + gis_onep_o)+(gis_twop_c + gis_twop_a + gis_twop_o)-(gis_onep_all + gis_twop_all)
gis_families = rowsum(gis_onep_a)+ rowsum(gis_cple_a)*0.5 + rowsum(gis_twop_a)*0.5
/*Household numbers*/
/*oneparent households*/
/*two parent households*/
/* multi family households*/
/*couple (no kids) households*/
/* sole person households*/
/*multi person households*/
/*non private dwelling i.e. not counted as a hh*/

gis_onep = (1:-multif_onep):*(rowsum(gis_onep_a))
gis_twop = (1:-multif_twop):*(rowsum(gis_twop_a)*0.5)
gis_onep_number_in_m = (multif_onep):*(rowsum(gis_onep_a))
gis_twop_number_in_m = ((multif_twop):*(rowsum(gis_twop_a)*0.5))
gis_multif = gis_onep_number_in_m + gis_twop_number_in_m 
gis_cple = rowsum(gis_cple_a)*0.5
gis_alon = rowsum(gis_alon_a) 
gis_multi = rowsum(gis_mult_o):/people_per_multi 
gis_nonhh = rowsum(gis_nonprv)


/*Household aggregates*/
/* this is the way statsnz calculates number of HH*/
/* this is the number of households consistent with the model*/

gis_households_aggr = gis_families:/fam_per_hh + rowsum(gis_mult_o):/people_per_multi + rowsum(gis_alon_a) 
gis_households = (gis_onep + gis_twop + gis_alon + gis_multif + gis_cple + gis_multi)
gis_people_per_hh = (gis_pop-gis_nonhh):/gis_households
gis_people_per_onep = (rowsum(gis_onep_c) + rowsum(gis_onep_a) + rowsum(gis_onep_o)):/rowsum(gis_onep_a)
gis_people_per_twop = (rowsum(gis_twop_c) + rowsum(gis_twop_a) + rowsum(gis_twop_o)):/(rowsum(gis_twop_a)*0.5)
gis_people_per_cple = (rowsum(gis_cple_a) + rowsum(gis_cple_o)):/gis_cple
gis_people_per_multif =  (((multif_onep):*(rowsum(gis_onep_a)+rowsum(gis_onep_c)+rowsum(gis_onep_o))) + ((multif_twop):*(rowsum(gis_twop_a)+rowsum(gis_twop_c)+rowsum(gis_twop_o)))):/gis_multif


gis_people_per_alon = J(TL,1,1)
gis_hh_size = (gis_people_per_alon,gis_people_per_onep,gis_people_per_twop,gis_people_per_multif,people_per_multi,gis_people_per_cple)
gis_hh_composition =(gis_alon,gis_onep,gis_twop,gis_multif,gis_multi,gis_cple)
gis_pop_by_hh_composition = gis_hh_composition:*gis_hh_size
gis_pop_by_hh_composition_shares = gis_pop_by_hh_composition:/J(1,6,gis_pop)

/*Average age of family units/LATRs and Households*/
/*assume no distinction in average age for thoe joining mutlifamily households*/
gis_onep_age = (gis_onep_all*Ages'):/(rowsum(gis_onep_all)) 
gis_twop_age = (gis_twop_all*Ages'):/(rowsum(gis_twop_all))
gis_alon_age = (gis_alon_all*Ages'):/(rowsum(gis_alon_all))
gis_mult_age = (gis_mult_all*Ages'):/(rowsum(gis_mult_all))
gis_cple_age = (gis_cple_all*Ages'):/(rowsum(gis_cple_all))
gis_multif_age = ((gis_onep_age:*gis_onep_number_in_m)+ (gis_twop_age:*gis_twop_number_in_m)):/gis_multif 
gis_hh_age = (gis_alon_age,gis_onep_age,gis_twop_age,gis_multif_age,gis_mult_age,gis_cple_age)

gis_onep_age_growth[2..rows(gis_onep_age_growth)] = diff(gis_onep_age):/gis_onep_age[Time_length-1,.] 
gis_twop_age_growth[2..rows(gis_twop_age_growth)] = diff(gis_onep_age):/gis_onep_age[Time_length-1,.] 
gis_alon_age_growth[2..rows(gis_alon_age_growth)] = diff(gis_alon_age):/gis_alon_age[Time_length-1,.] 
gis_mult_age_growth[2..rows(gis_mult_age_growth)] = diff(gis_mult_age):/gis_mult_age[Time_length-1,.] 
gis_cple_age_growth[2..rows(gis_cple_age_growth)] = diff(gis_cple_age):/gis_cple_age[Time_length-1,.] 
gis_multif_age_growth[2..rows(gis_multif_age_growth)] = diff(gis_multif_age):/gis_multif_age[Time_length-1,.]  

/*USI*/

/*(a) Project population by living arrangement*/

/*(i) first for each category of person and gender*/
usi_f_onep_c = usi_pop_fcast_f:*LATR_f[1..TL,.] 
usi_f_twop_c = usi_pop_fcast_f:*LATR_f[1+TL*1..TL+TL*1,.]
usi_f_alon_a = usi_pop_fcast_f:*LATR_f[1+TL*2..TL+TL*2,.]
usi_f_mult_o = usi_pop_fcast_f:*LATR_f[1+TL*3..TL+TL*3,.]
usi_f_cple_o = usi_pop_fcast_f:*LATR_f[1+TL*4..TL+TL*4,.]
usi_f_onep_o = usi_pop_fcast_f:*LATR_f[1+TL*5..TL+TL*5,.]
usi_f_twop_o = usi_pop_fcast_f:*LATR_f[1+TL*6..TL+TL*6,.]
usi_f_onep_a = usi_pop_fcast_f:*LATR_f[1+TL*7..TL+TL*7,.]
usi_f_cple_a = usi_pop_fcast_f:*LATR_f[1+TL*8..TL+TL*8,.]
usi_f_twop_a = usi_pop_fcast_f:*LATR_f[1+TL*9..TL+TL*9,.]
usi_f_nonprv = usi_pop_fcast_f:*LATR_f[1+TL*10..TL+TL*10,.]
usi_m_onep_c = usi_pop_fcast_m:*LATR_m[1..TL,.]
usi_m_twop_c = usi_pop_fcast_m:*LATR_m[1+TL*1..TL+TL*1,.]
usi_m_alon_a = usi_pop_fcast_m:*LATR_m[1+TL*2..TL+TL*2,.]
usi_m_mult_o = usi_pop_fcast_m:*LATR_m[1+TL*3..TL+TL*3,.]
usi_m_cple_o = usi_pop_fcast_m:*LATR_m[1+TL*4..TL+TL*4,.]
usi_m_onep_o = usi_pop_fcast_m:*LATR_m[1+TL*5..TL+TL*5,.]
usi_m_twop_o = usi_pop_fcast_m:*LATR_m[1+TL*6..TL+TL*6,.]
usi_m_onep_a = usi_pop_fcast_m:*LATR_m[1+TL*7..TL+TL*7,.]
usi_m_cple_a = usi_pop_fcast_m:*LATR_m[1+TL*8..TL+TL*8,.]
usi_m_twop_a = usi_pop_fcast_m:*LATR_m[1+TL*9..TL+TL*9,.]
usi_m_nonprv = usi_pop_fcast_m:*LATR_m[1+TL*10..TL+TL*10,.]

/*(ii) then aggregating over gender*/
usi_onep_c = usi_f_onep_c + usi_m_onep_c
usi_twop_c = usi_f_twop_c + usi_m_twop_c
usi_alon_a = usi_f_alon_a + usi_m_alon_a
usi_mult_o = usi_f_mult_o + usi_m_mult_o
usi_cple_o = usi_f_cple_o + usi_m_cple_o
usi_onep_o = usi_f_onep_o + usi_m_onep_o 
usi_twop_o = usi_f_twop_o + usi_m_twop_o  
usi_onep_a = usi_f_onep_a + usi_m_onep_a 
usi_cple_a = usi_f_cple_a + usi_m_cple_a
usi_twop_a = usi_f_twop_a + usi_m_twop_a 
usi_nonprv = usi_f_nonprv + usi_m_nonprv 

/* (iii) then summing over family types to give number of people, by age, in each living arrangement/family type*/

usi_onep_all = (usi_onep_c + usi_onep_a + usi_onep_o):*J(1,Ages_n,1:-multif_onep)
usi_twop_all = (usi_twop_c + usi_twop_a + usi_twop_o):*J(1,Ages_n,1:-multif_twop)
usi_alon_all = usi_alon_a
usi_mult_all = usi_mult_o
usi_cple_all = usi_cple_a + usi_cple_o
usi_multif_all = (usi_onep_c + usi_onep_a + usi_onep_o)+(usi_twop_c + usi_twop_a + usi_twop_o)-(usi_onep_all + usi_twop_all)
usi_families = rowsum(usi_onep_a)+ rowsum(usi_cple_a)*0.5 + rowsum(usi_twop_a)*0.5
/*Household numbers*/
/*oneparent households*/
/*two parent households*/
/* multi family households*/
/*couple (no kids) households*/
/* sole person households*/
/*multi person households*/
/*non private dwelling i.e. not counted as a hh*/

usi_onep = (1:-multif_onep):*(rowsum(usi_onep_a))
usi_twop = (1:-multif_twop):*(rowsum(usi_twop_a)*0.5)
usi_onep_number_in_m = (multif_onep):*(rowsum(usi_onep_a))
usi_twop_number_in_m = ((multif_twop):*(rowsum(usi_twop_a)*0.5))
usi_multif = usi_onep_number_in_m + usi_twop_number_in_m 
usi_cple = rowsum(usi_cple_a)*0.5
usi_alon = rowsum(usi_alon_a) 
usi_multi = rowsum(usi_mult_o):/people_per_multi 
usi_nonhh = rowsum(usi_nonprv)


/*Household aggregates*/
/* this is the way statsnz calculates number of HH*/
/* this is the number of households consistent with the model*/

usi_households_aggr = usi_families:/fam_per_hh + rowsum(usi_mult_o):/people_per_multi + rowsum(usi_alon_a) 
usi_households = (usi_onep + usi_twop + usi_alon + usi_multif + usi_cple + usi_multi)
usi_people_per_hh = (usi_pop-usi_nonhh):/usi_households
usi_people_per_onep = (rowsum(usi_onep_c) + rowsum(usi_onep_a) + rowsum(usi_onep_o)):/rowsum(usi_onep_a)
usi_people_per_twop = (rowsum(usi_twop_c) + rowsum(usi_twop_a) + rowsum(usi_twop_o)):/(rowsum(usi_twop_a)*0.5)
usi_people_per_cple = (rowsum(usi_cple_a) + rowsum(usi_cple_o)):/usi_cple
usi_people_per_multif =  (((multif_onep):*(rowsum(usi_onep_a)+rowsum(usi_onep_c)+rowsum(usi_onep_o))) + ((multif_twop):*(rowsum(usi_twop_a)+rowsum(usi_twop_c)+rowsum(usi_twop_o)))):/usi_multif


usi_people_per_alon = J(TL,1,1)
usi_hh_size = (usi_people_per_alon,usi_people_per_onep,usi_people_per_twop,usi_people_per_multif,people_per_multi,usi_people_per_cple)
usi_hh_composition =(usi_alon,usi_onep,usi_twop,usi_multif,usi_multi,usi_cple)
usi_pop_by_hh_composition = usi_hh_composition:*usi_hh_size
usi_pop_by_hh_composition_shares = usi_pop_by_hh_composition:/J(1,6,usi_pop)

/*Average age of family units/LATRs and Households*/
/*assume no distinction in average age for thoe joining mutlifamily households*/
usi_onep_age = (usi_onep_all*Ages'):/(rowsum(usi_onep_all))
usi_twop_age = (usi_twop_all*Ages'):/(rowsum(usi_twop_all))
usi_alon_age = (usi_alon_all*Ages'):/(rowsum(usi_alon_all))
usi_mult_age = (usi_mult_all*Ages'):/(rowsum(usi_mult_all))
usi_cple_age = (usi_cple_all*Ages'):/(rowsum(usi_cple_all))
usi_multif_age = ((usi_onep_age:*usi_onep_number_in_m)+ (usi_twop_age:*usi_twop_number_in_m)):/usi_multif 
usi_hh_age = (usi_alon_age,usi_onep_age,usi_twop_age,usi_multif_age,usi_mult_age,usi_cple_age)

usi_onep_age_growth[2..rows(usi_onep_age_growth)] = diff(usi_onep_age):/usi_onep_age[Time_length-1,.] 
usi_twop_age_growth[2..rows(usi_twop_age_growth)] = diff(usi_onep_age):/usi_onep_age[Time_length-1,.] 
usi_alon_age_growth[2..rows(usi_alon_age_growth)] = diff(usi_alon_age):/usi_alon_age[Time_length-1,.] 
usi_mult_age_growth[2..rows(usi_mult_age_growth)] = diff(usi_mult_age):/usi_mult_age[Time_length-1,.] 
usi_cple_age_growth[2..rows(usi_cple_age_growth)] = diff(usi_cple_age):/usi_cple_age[Time_length-1,.] 
usi_multif_age_growth[2..rows(usi_multif_age_growth)] = diff(usi_multif_age):/usi_multif_age[Time_length-1,.]  





/*COLLECT REGIONAL HH AND POPULATION NUMBER/AGGREGATES and Labour market*/
/*numbers*/
alon_reg = (nor_alon, akl_alon,wai_alon,bop_alon,tar_alon, man_alon, wel_alon,can_alon,otg_alon,sth_alon,gis_alon,usi_alon)
cple_reg = (nor_cple, akl_cple,wai_cple,bop_cple,tar_cple, man_cple, wel_cple,can_cple,otg_cple,sth_cple,gis_cple,usi_cple)
multi_reg = (nor_multi, akl_multi,wai_multi,bop_multi,tar_multi, man_multi, wel_multi,can_multi,otg_multi,sth_multi,gis_multi,usi_multi)
multif_reg = (nor_multif, akl_multif,wai_multif,bop_multif,tar_multif, man_multif, wel_multif,can_multif,otg_multif,sth_multif,gis_multif,usi_multif)
onep_reg = (nor_onep, akl_onep,wai_onep,bop_onep,tar_onep, man_onep, wel_onep,can_onep,otg_onep,sth_onep,gis_onep,usi_onep)
twop_reg = (nor_twop, akl_twop,wai_twop,bop_twop,tar_twop, man_twop, wel_twop,can_twop,otg_twop,sth_twop,gis_twop,usi_twop)



/*population by region*/
workage_pop_by_reg = (nor_pop_workage,akl_pop_workage, wai_pop_workage, bop_pop_workage, tar_pop_workage, man_pop_workage, wel_pop_workage, can_pop_workage, otg_pop_workage, sth_pop_workage, gis_pop_workage, usi_pop_workage) 
pop_by_reg = (nor_pop,akl_pop, wai_pop, bop_pop, tar_pop, man_pop, wel_pop, can_pop, otg_pop, sth_pop, gis_pop, usi_pop) 
/*households by region*/
reg_households = (nor_households,akl_households, wai_households, bop_households, tar_households, man_households, wel_households, can_households, otg_households, sth_households, gis_households, usi_households) 
reg_age_bands = (nor_age_bands,akl_age_bands, wai_age_bands, bop_age_bands, tar_age_bands, man_age_bands, wel_age_bands, can_age_bands, otg_age_bands, sth_age_bands, gis_age_bands, usi_age_bands) 

for (i=History_length+1; i<=Time_length; i++) {
reg_lfpr_fcast[i,.] = (reg_lfpr_fcast[i-1,.]+reg_lfpr_fcast[i-2,.]+reg_lfpr_fcast[i-3,.]+reg_lfpr_fcast[i-4,.])*(1/4)
reg_unemployment_fcast_rate[i,.] = reg_unemployment_fcast_rate[i-1,.] + ((reg_lr_unemployment_rate[1,.]-reg_unemployment_fcast_rate[i-1,.]):/reg_lr_unemployment_adjspeed[1,.])
}

reg_lf = reg_lfpr_fcast:*workage_pop_by_reg
reg_lf_growth[2..rows(reg_lf_growth),.] = diff(reg_lf):/reg_lf[1..Time_length-1,.]

reg_employment = reg_lf:*(1:-reg_unemployment_fcast_rate)
reg_employment_growth[2..rows(reg_employment_growth),.] = diff(reg_employment):/reg_employment[1..Time_length-1,.]

reg_employment_aggr = rowsum(reg_employment)
hh_hrt1 = (alon_reg,cple_reg,multi_reg,multif_reg,onep_reg,twop_reg)

/* Calibrating for the population trend */

/* SCENARIO: Adjust population to MBIE's */
pop_mbie2250=(5127970,5149490,5179310,5217280,5263710,5309290,5354050,5397960,5441000,5483110,5524190,5564430,5603700,5642140,5679740,5716600,5752840,5788430,5823270,5857480,5891140,5924040,5956180,5987770,6018420,6048120,6077050,6105240,6132460)'
hh_hrt1_sum = rowsum(hh_hrt1)
hh_hrt1_shr = hh_hrt1:/hh_hrt1_sum
hh_hrt1_base_cal = pop_mbie2250[1]/hh_hrt1_sum[31]
hh_hrt1_mul = hh_hrt1_base_cal:*hh_hrt1_sum[31..rows(pop)]
hh_hrt1_base_cal_pop = pop[30]/hh_hrt1_sum[30]
hhr_hrt1_mul_pop = hh_hrt1_base_cal_pop:*hh_hrt1_sum[1..30]
hh_hrt1_sum_cal = (hhr_hrt1_mul_pop[1..30]\hh_hrt1_mul)
pop21_smoothing = (pop[29]+pop_mbie2250[1])/2
hh_hrt1_sum_cal = pop[1..29]\pop21_smoothing\pop_mbie2250
hh_hrt1_cal = hh_hrt1_shr:*hh_hrt1_sum_cal
hh_hrt1_nocal = hh_hrt1
hh_hrt0 = hh_hrt1_cal

hh_composition_sum = rowsum(hh_composition)
hh_composition_sh = hh_composition:/hh_composition_sum
hh_composition0=hh_composition
hh_composition = hh_composition_sh:*hh_hrt1_sum_cal

workage_pop_by_reg_sum = rowsum(workage_pop_by_reg)
pop_cal = hh_hrt1_sum_cal:/pop
workage_pop_by_reg_shr = workage_pop_by_reg:/workage_pop_by_reg_sum
workage_pop_by_reg_cal = workage_pop_by_reg_shr:*pop_cal:*workage_pop_by_reg_sum
alon_reg = hh_hrt0[.,1..12]
cple_reg = hh_hrt0[.,13..24]
multi_reg = hh_hrt0[.,25..36]
multif_reg = hh_hrt0[.,37..48]
onep_reg = hh_hrt0[.,49..60]
twop_reg = hh_hrt0[.,61..72]
pop_by_reg_cal = hh_hrt1_sum_cal:/rowsum(pop_by_reg)
pop_by_reg_shr = pop_by_reg:/rowsum(pop_by_reg)
pop_by_reg = pop_by_reg_shr :* (pop_by_reg_cal:*rowsum(pop_by_reg))
workage_ratio = pop_workage:/pop
pop = rowsum(pop_by_reg)
pop_workage=round(workage_ratio:*pop,1)
end

/*
getmata ("nor" "akl" "wai" "bop" "tar" "man" "wel" "can" "otg" "sth" "gis" "usi") = pop_by_reg
g year = _n+1991
egen population = rowtotal(nor   akl   wai   bop   tar   man   wel   can   otg   sth   gis   usi   )
tsset year
tsline population
*/

